/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrPostfixExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class SideEffectChecker {
    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull GrExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker.mayHaveSideEffects must not be null");
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        exp.accept(visitor);
        return visitor.mayHaveSideEffects();
    }

    private static class SideEffectsVisitor
    extends GroovyRecursiveElementVisitor {
        private boolean mayHaveSideEffects = false;

        private SideEffectsVisitor() {
        }

        @Override
        public void visitElement(@NotNull GroovyPsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker$SideEffectsVisitor.visitElement must not be null");
            }
            if (!this.mayHaveSideEffects) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker$SideEffectsVisitor.visitAssignmentExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitAssignmentExpression(expression);
            this.mayHaveSideEffects = true;
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker$SideEffectsVisitor.visitMethodCallExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitMethodCallExpression(expression);
            this.mayHaveSideEffects = true;
        }

        @Override
        public void visitNewExpression(@NotNull GrNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker$SideEffectsVisitor.visitNewExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitNewExpression(expression);
            this.mayHaveSideEffects = true;
        }

        @Override
        public void visitPostfixExpression(@NotNull GrPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker$SideEffectsVisitor.visitPostfixExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitPostfixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(GroovyTokenTypes.mINC) || tokenType.equals(GroovyTokenTypes.mDEC)) {
                this.mayHaveSideEffects = true;
            }
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker$SideEffectsVisitor.visitUnaryExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitUnaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(GroovyTokenTypes.mINC) || tokenType.equals(GroovyTokenTypes.mDEC)) {
                this.mayHaveSideEffects = true;
            }
        }

        public boolean mayHaveSideEffects() {
            return this.mayHaveSideEffects;
        }
    }
}

