/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyStaticImportMethodFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.annotator.intentions.GroovyStaticImportMethodFix");
    private final SmartPsiElementPointer<GrCall> myMethodCall;
    private List<PsiMethod> myCandidates;

    public GroovyStaticImportMethodFix(@NotNull GrCall methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix.<init> must not be null");
        }
        this.myCandidates = null;
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @NotNull
    public String getText() {
        String text = "Static Import Method";
        if (this.getCandidates().size() == 1) {
            int options = 6145;
            text = text + " '" + PsiFormatUtil.formatMethod((PsiMethod)this.getCandidates().get(0), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0) + "'";
        } else {
            text = text + "...";
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix.getFamilyName must not return null");
        }
        return string;
    }

    @Nullable
    private static GrReferenceExpression getMethodExpression(GrCall call) {
        GrExpression result = null;
        if (call instanceof GrMethodCallExpression) {
            result = ((GrMethodCallExpression)call).getInvokedExpression();
        } else if (call instanceof GrApplicationStatement) {
            result = ((GrApplicationStatement)call).getFunExpression();
        }
        return result instanceof GrReferenceExpression ? (GrReferenceExpression)result : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix.isAvailable must not be null");
        }
        return this.myMethodCall != null && this.myMethodCall.getElement() != null && ((GrCall)this.myMethodCall.getElement()).isValid() && GroovyStaticImportMethodFix.getMethodExpression((GrCall)this.myMethodCall.getElement()) != null && GroovyStaticImportMethodFix.getMethodExpression((GrCall)this.myMethodCall.getElement()).getQualifierExpression() == null && file.getManager().isInProject((PsiElement)file) && file.getManager().isInProject((PsiElement)file) && !this.getCandidates().isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<PsiMethod> getMethodsToImport() {
        ArrayList<PsiMethod> arrayList;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myMethodCall.getProject());
        PsiShortNamesCache cache = facade.getShortNamesCache();
        GrCall element = (GrCall)this.myMethodCall.getElement();
        LOG.assertTrue(element != null);
        GrReferenceExpression reference = GroovyStaticImportMethodFix.getMethodExpression(element);
        LOG.assertTrue(reference != null);
        GrArgumentList argumentList = element.getArgumentList();
        String name = reference.getReferenceName();
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        if (name == null) {
            arrayList = list;
            if (arrayList == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix.getMethodsToImport must not return null");
            return arrayList;
        }
        GlobalSearchScope scope = element.getResolveScope();
        PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name, scope, 20);
        ArrayList<PsiMethod> applicableList = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            PsiFile file;
            ProgressManager.checkCanceled();
            PsiClass aClass = method.getContainingClass();
            if (aClass != null && JavaCompletionUtil.isInExcludedPackage((PsiClass)aClass) || !method.hasModifierProperty("static") || !((file = method.getContainingFile()) instanceof PsiClassOwner) || ((PsiClassOwner)file).getPackageName().length() == 0 || !PsiUtil.isAccessible(element, (PsiMember)method)) continue;
            list.add(method);
            if (!PsiUtil.isApplicable(PsiUtil.getArgumentTypes(element, true), method, PsiSubstitutor.EMPTY, false, element)) continue;
            applicableList.add(method);
        }
        ArrayList<PsiMethod> arrayList2 = applicableList.isEmpty() ? list : applicableList;
        Collections.sort(arrayList2, new PsiProximityComparator((PsiElement)argumentList));
        arrayList = arrayList2;
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix.getMethodsToImport must not return null");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite((PsiFile)file)) {
            return;
        }
        if (this.getCandidates().size() == 1) {
            PsiMethod toImport = this.getCandidates().get(0);
            this.doImport(toImport);
        } else {
            this.chooseAndImport(editor);
        }
    }

    private void doImport(final PsiMethod toImport) {
        CommandProcessor.getInstance().executeCommand(toImport.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GrCall element = (GrCall)GroovyStaticImportMethodFix.this.myMethodCall.getElement();
                            if (element != null) {
                                GroovyStaticImportMethodFix.getMethodExpression(element).bindToElementViaStaticImport(toImport.getContainingClass());
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, this.getText(), (Object)this);
    }

    private void chooseAndImport(Editor editor) {
        final JList<PsiMethod> list = new JList<PsiMethod>(this.getCandidates().toArray(new PsiMethod[this.getCandidates().size()]));
        list.setCellRenderer((ListCellRenderer<PsiMethod>)new MethodCellRenderer(true));
        new PopupChooserBuilder(list).setTitle(QuickFixBundle.message((String)"static.import.method.choose.method.to.import", (Object[])new Object[0])).setMovable(true).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                PsiMethod selectedValue = (PsiMethod)list.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                LOG.assertTrue(selectedValue.isValid());
                GroovyStaticImportMethodFix.this.doImport(selectedValue);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private List<PsiMethod> getCandidates() {
        if (this.myCandidates == null) {
            this.myCandidates = this.getMethodsToImport();
        }
        return this.myCandidates;
    }
}

