/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;

public class GrModifierFix
implements IntentionAction {
    @NotNull
    private final PsiMember myMember;
    private final String myModifier;
    private final boolean myShowContainingClass;
    private final PsiModifierList myModifierList;
    private final boolean myDoSet;

    public GrModifierFix(@NotNull PsiMember member, @NotNull PsiModifierList modifierList, String modifier, boolean showContainingClass, boolean doSet) {
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/GrModifierFix.<init> must not be null");
        }
        if (modifierList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/GrModifierFix.<init> must not be null");
        }
        this.myMember = member;
        this.myModifier = modifier;
        this.myShowContainingClass = showContainingClass;
        this.myModifierList = modifierList;
        this.myDoSet = doSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getText() {
        String string;
        String name;
        if (this.myShowContainingClass) {
            PsiClass containingClass = this.myMember.getContainingClass();
            String containingClassName = containingClass != null ? containingClass.getName() + "." : "";
            name = containingClassName + this.myMember.getName();
        } else {
            name = this.myMember.getName();
        }
        String modifierText = GrModifierFix.toPresentableText(this.myModifier);
        if (this.myDoSet) {
            string = GroovyBundle.message("change.modifier", name, modifierText);
            if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/GrModifierFix.getText must not return null");
            return string;
        }
        string = GroovyBundle.message("change.modifier.not", name, modifierText);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/GrModifierFix.getText must not return null");
    }

    private static String toPresentableText(String modifier) {
        return GroovyBundle.message(modifier + ".visibility.presentation", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("change.modifier.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/GrModifierFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/GrModifierFix.isAvailable must not be null");
        }
        return this.myModifierList != null && this.myModifierList.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/GrModifierFix.invoke must not be null");
        }
        this.myModifierList.setModifierProperty(this.myModifier, this.myDoSet);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

