/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.MemberChooserBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.GenerateToStringActionHandler;
import org.jetbrains.generate.tostring.GenerateToStringConfigurable;
import org.jetbrains.generate.tostring.GenerateToStringContext;
import org.jetbrains.generate.tostring.GenerateToStringUtils;
import org.jetbrains.generate.tostring.GenerateToStringWorker;
import org.jetbrains.generate.tostring.config.Config;
import org.jetbrains.generate.tostring.psi.PsiAdapter;
import org.jetbrains.generate.tostring.psi.PsiAdapterFactory;
import org.jetbrains.generate.tostring.template.TemplateResource;
import org.jetbrains.generate.tostring.template.TemplatesManager;
import org.jetbrains.generate.tostring.view.TemplatesPanel;

public class GenerateToStringActionHandlerImpl
extends EditorWriteActionHandler
implements GenerateToStringActionHandler {
    private static final Logger logger = Logger.getInstance((String)"#org.jetbrains.generate.tostring.GenerateToStringActionHandlerImpl");

    @Override
    public void executeWriteAction(Editor editor, DataContext dataContext) {
        Project project = (Project)LangDataKeys.PROJECT.getData(dataContext);
        assert (project != null);
        PsiClass clazz = GenerateToStringActionHandlerImpl.getSubjectClass(editor, dataContext);
        assert (clazz != null);
        GenerateToStringActionHandlerImpl.doExecuteAction(project, clazz, editor);
    }

    @Override
    public void executeActionQickFix(Project project, PsiClass clazz) {
        GenerateToStringActionHandlerImpl.doExecuteAction(project, clazz, null);
    }

    private static void doExecuteAction(@NotNull Project project, final @NotNull PsiClass clazz, final Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/generate/tostring/GenerateToStringActionHandlerImpl.doExecuteAction must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/generate/tostring/GenerateToStringActionHandlerImpl.doExecuteAction must not be null");
        }
        logger.debug("+++ doExecuteAction - START +++");
        if (logger.isDebugEnabled()) {
            logger.debug("Current project " + project.getName());
        }
        PsiElementClassMember[] dialogMembers = GenerateToStringActionHandlerImpl.buildMembersToShow(clazz);
        MemberChooserBuilder builder = new MemberChooserBuilder(project);
        final MemberChooserHeaderPanel header = new MemberChooserHeaderPanel(clazz);
        builder.setHeaderPanel((JComponent)header);
        boolean isJdk15Enabled = PsiUtil.isLanguageLevel5OrHigher((PsiElement)clazz);
        builder.overrideAnnotationVisible(isJdk15Enabled);
        builder.setTitle(GenerateToStringActionHandlerImpl.calcCurrentTitle());
        final MemberChooser dialog = builder.createBuilder((ClassMember[])dialogMembers);
        dialog.setCopyJavadocVisible(false);
        dialog.selectElements((ClassMember[])dialogMembers);
        header.setChooser(dialog);
        logger.debug("Displaying member chooser dialog");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.show();
                if (0 == dialog.getExitCode()) {
                    List<PsiMember> selectedMembers = GenerateToStringUtils.convertClassMembersToPsiMembers(dialog.getSelectedElements());
                    TemplateResource template = header.getSelectedTemplate();
                    TemplatesManager.getInstance().setDefaultTemplate(template);
                    if (template.isValidTemplate()) {
                        GenerateToStringWorker.executeGenerateActionLater(clazz, editor, selectedMembers, template, dialog.isInsertOverrideAnnotation());
                    } else {
                        Messages.showWarningDialog((String)"The template chosen is invalid.", (String)"Broken Template");
                    }
                }
            }
        });
        logger.debug("+++ doExecuteAction - END +++");
    }

    private static String calcCurrentTitle() {
        TemplateResource template = TemplatesManager.getInstance().getDefaultTemplate();
        if (template.isValidTemplate()) {
            return "Generate " + template.getTargetMethodName();
        }
        return "Generate";
    }

    public static void updateDialog(PsiClass clazz, MemberChooser<PsiElementClassMember> dialog) {
        dialog.setTitle(GenerateToStringActionHandlerImpl.calcCurrentTitle());
        PsiElementClassMember[] members = GenerateToStringActionHandlerImpl.buildMembersToShow(clazz);
        dialog.resetElements((ClassMember[])members);
        dialog.selectElements((ClassMember[])members);
    }

    private static PsiElementClassMember[] buildMembersToShow(PsiClass clazz) {
        Project project = clazz.getProject();
        PsiAdapter psi = PsiAdapterFactory.getPsiAdapter();
        Config config = GenerateToStringContext.getConfig();
        PsiField[] filteredFields = GenerateToStringUtils.filterAvailableFields(project, psi, clazz, config.getFilterPattern());
        if (logger.isDebugEnabled()) {
            logger.debug("Number of fields after filtering: " + filteredFields.length);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Number of fields after filtering: " + filteredFields.length);
        }
        PsiMethod[] filteredMethods = new PsiMethod[]{};
        if (config.enableMethods) {
            filteredMethods = GenerateToStringUtils.filterAvailableMethods(psi, clazz, config.getFilterPattern());
            if (logger.isDebugEnabled()) {
                logger.debug("Number of methods after filtering: " + filteredMethods.length);
            }
        }
        return GenerateToStringUtils.combineToClassMemberList(filteredFields, filteredMethods);
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return GenerateToStringActionHandlerImpl.getSubjectClass(editor, dataContext) != null;
    }

    @Nullable
    private static PsiClass getSubjectClass(Editor editor, DataContext dataContext) {
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement context = file.findElementAt(offset);
        if (context == null) {
            return null;
        }
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class, (boolean)false);
        if (clazz == null) {
            return null;
        }
        return clazz.isInterface() ? null : clazz;
    }

    public static class MemberChooserHeaderPanel
    extends JPanel {
        private MemberChooser chooser;
        private final JComboBox comboBox;

        public void setChooser(MemberChooser chooser) {
            this.chooser = chooser;
        }

        public MemberChooserHeaderPanel(final PsiClass clazz) {
            super(new BorderLayout());
            Collection<TemplateResource> templates = TemplatesManager.getInstance().getAllTemplates();
            TemplateResource[] all = templates.toArray(new TemplateResource[templates.size()]);
            JButton settingsButton = new JButton("Settings");
            settingsButton.setMnemonic(83);
            this.comboBox = new JComboBox<TemplateResource>(all);
            settingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final TemplatesPanel ui = new TemplatesPanel();
                    Disposable disposable = Disposer.newDisposable();
                    TabbedConfigurable composite = new TabbedConfigurable(disposable){

                        protected List<Configurable> createConfigurables() {
                            ArrayList<Configurable> res = new ArrayList<Configurable>();
                            res.add(new GenerateToStringConfigurable());
                            res.add((Configurable)ui);
                            return res;
                        }

                        public String getDisplayName() {
                            return "toString() Generation Settings";
                        }

                        public Icon getIcon() {
                            return null;
                        }

                        public String getHelpTopic() {
                            return null;
                        }

                        public void apply() throws ConfigurationException {
                            super.apply();
                            GenerateToStringActionHandlerImpl.updateDialog(clazz, (MemberChooser<PsiElementClassMember>)MemberChooserHeaderPanel.this.chooser);
                            MemberChooserHeaderPanel.this.comboBox.setSelectedItem(TemplatesManager.getInstance().getDefaultTemplate());
                        }
                    };
                    ShowSettingsUtil.getInstance().editConfigurable((Component)MemberChooserHeaderPanel.this, (Configurable)composite, new Runnable(){

                        @Override
                        public void run() {
                            ui.selectItem(TemplatesManager.getInstance().getDefaultTemplate());
                        }
                    });
                    Disposer.dispose((Disposable)disposable);
                }
            });
            this.add((Component)settingsButton, "East");
            this.add((Component)this.comboBox, "Center");
            this.comboBox.setSelectedItem(TemplatesManager.getInstance().getDefaultTemplate());
            JLabel templatesLabel = new JLabel("Template: ");
            templatesLabel.setDisplayedMnemonic('T');
            templatesLabel.setLabelFor(this.comboBox);
            this.add((Component)templatesLabel, "West");
        }

        public TemplateResource getSelectedTemplate() {
            return (TemplateResource)this.comboBox.getSelectedItem();
        }
    }
}

