/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import com.siyeh.ipp.switchtoif.CaseUtil;

class IfToSwitchPredicate
implements PsiElementPredicate {
    IfToSwitchPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.IF_KEYWORD) {
            return false;
        }
        if (!(element.getParent() instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement statement = (PsiIfStatement)element.getParent();
        if (ErrorUtil.containsError((PsiElement)statement)) {
            return false;
        }
        return CaseUtil.getCaseExpression(statement) != null;
    }
}

