/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiSelectionSearcher {
    private PsiSelectionSearcher() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T extends PsiElement> List<T> searchElementsInSelection(Editor editor, Project project, final Class<T> filter, final boolean dontStopOnFound) {
        List list;
        final TextRange selection = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null || file instanceof PsiCompiledElement) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ipp/psiutils/PsiSelectionSearcher.searchElementsInSelection must not return null");
            return list;
        }
        final ArrayList results = new ArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!selection.intersects(element.getTextRange())) {
                    return;
                }
                if (filter.isAssignableFrom(element.getClass())) {
                    results.add(element);
                    if (dontStopOnFound) {
                        super.visitElement(element);
                    }
                } else {
                    super.visitElement(element);
                }
            }
        };
        file.accept((PsiElementVisitor)visitor);
        list = results;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/siyeh/ipp/psiutils/PsiSelectionSearcher.searchElementsInSelection must not return null");
    }
}

