/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonUtils {
    private static final Set<IElementType> comparisons = new HashSet<IElementType>(6);
    private static final Map<IElementType, String> flippedComparisons = new HashMap<IElementType, String>(6);
    private static final Map<IElementType, String> negatedComparisons = new HashMap<IElementType, String>(6);

    private ComparisonUtils() {
    }

    public static boolean isComparison(@Nullable PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        return ComparisonUtils.isComparison(tokenType);
    }

    public static boolean isComparison(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/ComparisonUtils.isComparison must not be null");
        }
        return comparisons.contains(tokenType);
    }

    public static String getFlippedComparison(@NotNull PsiJavaToken sign) {
        if (sign == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/ComparisonUtils.getFlippedComparison must not be null");
        }
        IElementType text = sign.getTokenType();
        return ComparisonUtils.getFlippedComparison(text);
    }

    public static String getFlippedComparison(IElementType text) {
        return flippedComparisons.get(text);
    }

    public static String getNegatedComparison(@NotNull PsiJavaToken sign) {
        if (sign == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/ComparisonUtils.getNegatedComparison must not be null");
        }
        IElementType tokenType = sign.getTokenType();
        return ComparisonUtils.getNegatedComparison(tokenType);
    }

    public static String getNegatedComparison(IElementType tokenType) {
        return negatedComparisons.get(tokenType);
    }

    static {
        comparisons.add(JavaTokenType.EQEQ);
        comparisons.add(JavaTokenType.NE);
        comparisons.add(JavaTokenType.GT);
        comparisons.add(JavaTokenType.LT);
        comparisons.add(JavaTokenType.GE);
        comparisons.add(JavaTokenType.LE);
        flippedComparisons.put(JavaTokenType.EQEQ, "==");
        flippedComparisons.put(JavaTokenType.NE, "!=");
        flippedComparisons.put(JavaTokenType.GT, "<");
        flippedComparisons.put(JavaTokenType.LT, ">");
        flippedComparisons.put(JavaTokenType.GE, "<=");
        flippedComparisons.put(JavaTokenType.LE, ">=");
        negatedComparisons.put(JavaTokenType.EQEQ, "!=");
        negatedComparisons.put(JavaTokenType.NE, "==");
        negatedComparisons.put(JavaTokenType.GT, "<=");
        negatedComparisons.put(JavaTokenType.LT, ">=");
        negatedComparisons.put(JavaTokenType.GE, "<");
        negatedComparisons.put(JavaTokenType.LE, ">");
    }
}

