/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Observable;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.BasePainter;
import net.sourceforge.jnlp.splashscreen.parts.BasicComponentSplashScreen;
import net.sourceforge.jnlp.splashscreen.parts.InformationElement;

public final class ErrorPainter
extends BasePainter {
    private static final Color TEA_DEAD_COLOR = Color.darkGray;
    private static final Color BACKGROUND_DEAD_COLOR = Color.gray;
    private static final Color TEA_LEAFS_STALKS_DEAD_COLOR = new Color(100, 100, 100);
    private static final Color PLUGIN_DEAD_COLOR = Color.darkGray;
    private static final Color WATER_DEAD_COLOR = Color.darkGray;
    private static final Color PLAIN_TEXT_DEAD_COLOR = Color.white;
    private static final String ERROR_MESSAGE_KEY = "SPLASHerror";
    private static final String ERROR_FLY_MESSAGE_KEY = "SPLASH_ERROR";
    private static final Color ERROR_FLY_COLOR = Color.red;
    private Point errorCorner = null;
    private boolean errorIsFlying = false;
    private int errorFlyPercentage = 100;

    public static double interpol(double origSize, double currentSize, double from, double to) {
        return ErrorPainter.getRatio(origSize, currentSize) * (to - from) + from;
    }

    public static Color interpolateColor(double origSize, double currentSize, Color from, Color to) {
        double r = ErrorPainter.interpol(origSize, currentSize, to.getRed(), from.getRed());
        double g = ErrorPainter.interpol(origSize, currentSize, to.getGreen(), from.getGreen());
        double b = ErrorPainter.interpol(origSize, currentSize, to.getBlue(), from.getBlue());
        double a = ErrorPainter.interpol(origSize, currentSize, to.getAlpha(), from.getAlpha());
        return new Color((int)r, (int)g, (int)b, (int)a);
    }

    public ErrorPainter(BasicComponentSplashScreen master) {
        this(master, false);
    }

    public ErrorPainter(BasicComponentSplashScreen master, boolean startScream) {
        super(master);
        if (startScream) {
            this.startErrorScream();
        }
    }

    public void startErrorScream() {
        this.errorIsFlying = true;
        this.getFlyingRedErrorTextThread().start();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.ensurePrerenderedStuff();
        if (this.errorIsFlying) {
            this.paintStillTo(g2d, this.master.getInformationElement(), this.master.getVersion());
        } else if (this.prerenderedStuff != null) {
            g2d.drawImage((Image)this.prerenderedStuff, 0, 0, null);
        }
        if (this.showNiceTexts) {
            this.paintNiceTexts(g2d);
        } else {
            this.paintPlainTexts(g2d);
        }
        if (this.errorIsFlying) {
            g2d.setClip(0, 0, this.master.getSplashWidth(), this.master.getSplashHeight());
            this.drawBigError(g2d);
        }
    }

    private void drawBigError(Graphics2D g2d) {
        Font f = new Font("Serif", 0, (int)ErrorPainter.scale(100.0, this.errorFlyPercentage, this.master.getSplashHeight()));
        g2d.setColor(ERROR_FLY_COLOR);
        g2d.setFont(f);
        this.drawTextAroundCenter(g2d, 0.0, this.geFlyingErrorMessage());
    }

    public Point getErrorCorner() {
        return this.errorCorner;
    }

    private void setColors() {
        this.teaColor = TEA_DEAD_COLOR;
        this.backgroundColor = BACKGROUND_DEAD_COLOR;
        this.teaLeafsStalksColor = TEA_LEAFS_STALKS_DEAD_COLOR;
        this.pluginColor = PLUGIN_DEAD_COLOR;
        this.waterColor = WATER_DEAD_COLOR;
    }

    private void interpolateColor(int origSize, int currentSize) {
        this.teaColor = ErrorPainter.interpolateColor(origSize, currentSize, TEA_LIVE_COLOR, TEA_DEAD_COLOR);
        this.backgroundColor = ErrorPainter.interpolateColor(origSize, currentSize, BACKGROUND_LIVE_COLOR, BACKGROUND_DEAD_COLOR);
        this.teaLeafsStalksColor = ErrorPainter.interpolateColor(origSize, currentSize, TEA_LEAFS_STALKS_LIVE_COLOR, TEA_LEAFS_STALKS_DEAD_COLOR);
        this.pluginColor = ErrorPainter.interpolateColor(origSize, currentSize, PLUGIN_LIVE_COLOR, PLUGIN_DEAD_COLOR);
        this.waterColor = ErrorPainter.interpolateColor(origSize, currentSize, WATER_LIVE_COLOR, WATER_DEAD_COLOR);
        this.plainTextColor = ErrorPainter.interpolateColor(origSize, currentSize, PLAIN_TEXT_LIVE_COLOR, PLAIN_TEXT_DEAD_COLOR);
    }

    @Override
    protected void paintStillTo(Graphics2D g2d, InformationElement ic, String version) {
        RenderingHints r = g2d.getRenderingHints();
        FontMetrics fm = this.drawBase(g2d, ic, version);
        this.drawError(g2d, ic, version, fm);
        g2d.setRenderingHints(r);
    }

    private String getErrorMessage() {
        String localised = Translator.R(ERROR_MESSAGE_KEY);
        return localised;
    }

    private String geFlyingErrorMessage() {
        String localised = Translator.R(ERROR_FLY_MESSAGE_KEY);
        return localised;
    }

    private Thread getFlyingRedErrorTextThread() {
        Thread t = new Thread(new FlyingRedErrorTextRunner(this));
        return t;
    }

    private void drawError(Graphics2D g2d, InformationElement ic, String version, FontMetrics fm) {
        int minh = fm.getHeight();
        int minw = fm.stringWidth(this.getErrorMessage());
        int space = 5;
        g2d.setColor(this.backgroundColor);
        this.errorCorner = new Point(this.master.getSplashWidth() - space * 4 - minw, this.master.getSplashHeight() - space * 4 - minh);
        if (this.errorCorner.x < 0) {
            this.errorCorner.x = 0;
        }
        g2d.fillRect(this.errorCorner.x, this.errorCorner.y, space * 4 + minw, space * 4 + minh);
        g2d.setColor(this.plainTextColor);
        g2d.drawRect(this.errorCorner.x + space, this.errorCorner.y + space, space * 2 + minw, space * 2 + minh);
        g2d.drawString(this.getErrorMessage(), this.errorCorner.x + 2 * space, this.errorCorner.y + 5 * space);
    }

    private final class FlyingRedErrorTextRunner
    extends Observable
    implements Runnable {
        private static final int FLYING_ERROR_PERCENTAGE_INCREMENT = -3;
        private static final int FLYING_ERROR_PERCENTAGE_MINIMUM = 5;
        private static final int FLYING_ERROR_PERCENTAGE_LOWER_BOUND = 80;
        private static final int FLYING_ERROR_PERCENTAGE_UPPER_BOUND = 90;
        private static final int FLYING_ERROR_DELAY = 75;

        private FlyingRedErrorTextRunner(ErrorPainter o) {
            this.addObserver(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (ErrorPainter.this.errorIsFlying) {
                    ErrorPainter.this.errorFlyPercentage += -3;
                    ErrorPainter.this.interpolateColor(100, ErrorPainter.this.errorFlyPercentage);
                    if (ErrorPainter.this.errorFlyPercentage <= 5) {
                        ErrorPainter.this.errorIsFlying = false;
                        ErrorPainter.this.setColors();
                        ErrorPainter.this.prerenderedStuff = null;
                    }
                    this.setChanged();
                    this.notifyObservers();
                    Thread.sleep(75L);
                    if (ErrorPainter.this.errorFlyPercentage >= 90 || ErrorPainter.this.errorFlyPercentage <= 80) continue;
                    ErrorPainter.this.clearCachedWaterTextImage();
                    ErrorPainter.this.canWave = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ErrorPainter.this.canWave = true;
                ErrorPainter.this.errorIsFlying = false;
                ErrorPainter.this.setColors();
                ErrorPainter.this.prerenderedStuff = null;
                ErrorPainter.this.master.repaint();
            }
        }
    }
}

