/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.UnsignedAppletTrustWarningPanel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletStartupSecuritySettings;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteUnsignedApplet;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionStorage;
import net.sourceforge.jnlp.security.appletextendedsecurity.UrlRegEx;
import net.sourceforge.jnlp.util.UrlUtils;

public class UnsignedAppletTrustConfirmation {
    private static final boolean DEBUG = System.getenv().containsKey("ICEDTEAPLUGIN_DEBUG");
    private static final AppletStartupSecuritySettings securitySettings = AppletStartupSecuritySettings.getInstance();

    private static boolean unsignedConfirmationIsRequired() {
        return AppletSecurityLevel.ALLOW_UNSIGNED != securitySettings.getSecurityLevel();
    }

    private static boolean unsignedAppletsAreForbidden() {
        return AppletSecurityLevel.DENY_UNSIGNED == securitySettings.getSecurityLevel() || AppletSecurityLevel.DENY_ALL == securitySettings.getSecurityLevel();
    }

    public static ExecuteUnsignedApplet getStoredAction(PluginBridge file) {
        ExecuteUnsignedApplet userAction;
        UnsignedAppletActionStorage userActionStorage = securitySettings.getUnsignedAppletActionCustomStorage();
        UnsignedAppletActionStorage globalActionStorage = securitySettings.getUnsignedAppletActionGlobalStorage();
        UnsignedAppletActionEntry globalEntry = UnsignedAppletTrustConfirmation.getMatchingItem(globalActionStorage, file);
        UnsignedAppletActionEntry userEntry = UnsignedAppletTrustConfirmation.getMatchingItem(userActionStorage, file);
        ExecuteUnsignedApplet globalAction = globalEntry == null ? null : globalEntry.getUnsignedAppletAction();
        ExecuteUnsignedApplet executeUnsignedApplet = userAction = userEntry == null ? null : userEntry.getUnsignedAppletAction();
        if (userAction == ExecuteUnsignedApplet.ALWAYS || userAction == ExecuteUnsignedApplet.NEVER) {
            return userAction;
        }
        if (globalAction == ExecuteUnsignedApplet.ALWAYS || globalAction == ExecuteUnsignedApplet.NEVER) {
            return globalAction;
        }
        return userAction;
    }

    private static UnsignedAppletActionEntry getMatchingItem(UnsignedAppletActionStorage actionStorage, PluginBridge file) {
        return actionStorage.getMatchingItem(UrlUtils.normalizeUrlAndStripParams(file.getSourceLocation(), true).toString(), UrlUtils.normalizeUrlAndStripParams(file.getCodeBase(), true).toString(), UnsignedAppletTrustConfirmation.toRelativePaths(file.getArchiveJars(), file.getCodeBase().toString()));
    }

    static List<String> toRelativePaths(List<String> paths, String rootPath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String path : paths) {
            if (path.startsWith(rootPath)) {
                fileNames.add(path.substring(rootPath.length()));
                continue;
            }
            fileNames.add(path);
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAppletAction(PluginBridge file, ExecuteUnsignedApplet behaviour, boolean rememberForCodeBase) {
        UnsignedAppletActionStorage userActionStorage = securitySettings.getUnsignedAppletActionCustomStorage();
        userActionStorage.lock();
        try {
            UnsignedAppletActionEntry oldEntry = UnsignedAppletTrustConfirmation.getMatchingItem(userActionStorage, file);
            if (oldEntry != null) {
                oldEntry.setUnsignedAppletAction(behaviour);
                oldEntry.setTimeStamp(new Date());
                userActionStorage.update(oldEntry);
                return;
            }
            URL codebase = UrlUtils.normalizeUrlAndStripParams(file.getCodeBase(), true);
            URL documentbase = UrlUtils.normalizeUrlAndStripParams(file.getSourceLocation(), true);
            UrlRegEx codebaseRegex = new UrlRegEx("\\Q" + codebase + "\\E");
            UrlRegEx documentbaseRegex = new UrlRegEx(".*");
            List<String> archiveMatches = null;
            if (!rememberForCodeBase) {
                documentbaseRegex = new UrlRegEx("\\Q" + documentbase + "\\E");
                archiveMatches = UnsignedAppletTrustConfirmation.toRelativePaths(file.getArchiveJars(), file.getCodeBase().toString());
            }
            UnsignedAppletActionEntry entry = new UnsignedAppletActionEntry(behaviour, new Date(), documentbaseRegex, codebaseRegex, archiveMatches);
            userActionStorage.add(entry);
        }
        finally {
            userActionStorage.unlock();
        }
    }

    private static void debug(String logMessage) {
        if (DEBUG) {
            System.err.println(logMessage);
        }
    }

    public static void checkUnsignedWithUserIfRequired(PluginBridge file) throws LaunchException {
        boolean appletOK;
        if (UnsignedAppletTrustConfirmation.unsignedAppletsAreForbidden()) {
            UnsignedAppletTrustConfirmation.debug("Not running unsigned applet at " + file.getCodeBase() + " because unsigned applets are disallowed by security policy.");
            throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletPolicyDenied"));
        }
        if (!UnsignedAppletTrustConfirmation.unsignedConfirmationIsRequired()) {
            UnsignedAppletTrustConfirmation.debug("Running unsigned applet at " + file.getCodeBase() + " does not require confirmation according to security policy.");
            return;
        }
        ExecuteUnsignedApplet storedAction = UnsignedAppletTrustConfirmation.getStoredAction(file);
        UnsignedAppletTrustConfirmation.debug("Stored action for unsigned applet at " + file.getCodeBase() + " was " + (Object)((Object)storedAction));
        if (storedAction == ExecuteUnsignedApplet.ALWAYS) {
            appletOK = true;
        } else if (storedAction == ExecuteUnsignedApplet.NEVER) {
            appletOK = false;
        } else {
            UnsignedAppletTrustWarningPanel.UnsignedWarningAction warningResponse = SecurityDialogs.showUnsignedWarningDialog(file);
            ExecuteUnsignedApplet executeAction = warningResponse.getAction();
            boolean bl = appletOK = executeAction == ExecuteUnsignedApplet.YES || executeAction == ExecuteUnsignedApplet.ALWAYS;
            if (executeAction != null) {
                UnsignedAppletTrustConfirmation.updateAppletAction(file, executeAction, warningResponse.rememberForCodeBase());
            }
            UnsignedAppletTrustConfirmation.debug("Decided action for unsigned applet at " + file.getCodeBase() + " was " + (Object)((Object)executeAction));
        }
        if (!appletOK) {
            throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletUserDenied"));
        }
    }
}

