/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.util.Enumeration;
import java.util.Properties;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.JNLPAuthenticator;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletSecurityContext;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginCallRequestFactory;
import sun.applet.PluginCookieManager;
import sun.applet.PluginDebug;
import sun.applet.PluginProxySelector;
import sun.applet.PluginStreamHandler;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class PluginMain {
    public static final String PLUGIN_STDERR_FILE = "java.stderr";
    public static final String PLUGIN_STDOUT_FILE = "java.stdout";
    private static final String theVersion = System.getProperty("java.version");

    public static void main(String[] args) throws IOException {
        if (AppContext.getAppContext() == null) {
            SunToolkit.createNewAppContext();
        }
        if (args.length != 2 || !new File(args[0]).exists() || !new File(args[1]).exists()) {
            System.err.println("Invalid pipe names provided. Refusing to proceed.");
            System.exit(1);
        }
        try {
            PluginStreamHandler streamHandler = PluginMain.connect(args[0], args[1]);
            boolean redirectStreams = System.getenv().containsKey("ICEDTEAPLUGIN_DEBUG");
            JNLPRuntime.setRedirectStreams((boolean)redirectStreams);
            PluginAppletSecurityContext sc = new PluginAppletSecurityContext(0);
            sc.prePopulateLCClasses();
            PluginAppletSecurityContext.setStreamhandler(streamHandler);
            AppletSecurityContextManager.addContext(0, sc);
            PluginAppletViewer.setStreamhandler(streamHandler);
            PluginAppletViewer.setPluginCallRequestFactory(new PluginCallRequestFactory());
            PluginMain.init();
            streamHandler.startProcessing();
            PluginMain.setCookieHandler(streamHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Something very bad happened. I don't know what to do, so I am going to exit :(");
            System.exit(1);
        }
    }

    private PluginMain() {
    }

    private static PluginStreamHandler connect(String inPipe, String outPipe) {
        PluginStreamHandler streamHandler = null;
        try {
            streamHandler = new PluginStreamHandler(new FileInputStream(inPipe), new FileOutputStream(outPipe));
            PluginDebug.debug("Streams initialized");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return streamHandler;
    }

    private static void init() {
        Properties avProps = new Properties();
        avProps.put("browser", "sun.applet.AppletViewer");
        avProps.put("browser.version", "1.06");
        avProps.put("browser.vendor", "Sun Microsystems Inc.");
        avProps.put("http.agent", "Java(tm) 2 SDK, Standard Edition v" + theVersion);
        avProps.put("package.restrict.definition.java", "true");
        avProps.put("package.restrict.definition.sun", "true");
        avProps.put("java.version.applet", "true");
        avProps.put("java.vendor.applet", "true");
        avProps.put("java.vendor.url.applet", "true");
        avProps.put("java.class.version.applet", "true");
        avProps.put("os.name.applet", "true");
        avProps.put("os.version.applet", "true");
        avProps.put("os.arch.applet", "true");
        avProps.put("file.separator.applet", "true");
        avProps.put("path.separator.applet", "true");
        avProps.put("line.separator.applet", "true");
        avProps.put("javaplugin.nodotversion", "160_17");
        avProps.put("javaplugin.version", "1.6.0_17");
        avProps.put("javaplugin.vm.options", "");
        Properties sysProps = System.getProperties();
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = sysProps.getProperty(key);
            avProps.setProperty(key, val);
        }
        System.setProperties(avProps);
        boolean installAuthenticator = Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.security.authenticator"));
        if (installAuthenticator) {
            Authenticator.setDefault((Authenticator)new JNLPAuthenticator());
        }
        ProxySelector.setDefault((ProxySelector)((Object)new PluginProxySelector()));
    }

    private static void setCookieHandler(PluginStreamHandler streamHandler) {
        PluginCookieManager ckManager = new PluginCookieManager(streamHandler);
        CookieHandler.setDefault(ckManager);
    }
}

