/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.NetxPanel;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.splashscreen.SplashController;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;
import sun.applet.PluginStreamHandler;

class PluginAppletPanelFactory {
    PluginAppletPanelFactory() {
    }

    public AppletPanel createPanel(PluginStreamHandler streamhandler, final int identifier, final long handle, final URL doc, final PluginParameters params) {
        final NetxPanel panel = AccessController.doPrivileged(new PrivilegedAction<NetxPanel>(){

            @Override
            public NetxPanel run() {
                NetxPanel panel = new NetxPanel(doc, params);
                NetxPanel.debug((String)"Using NetX panel");
                PluginDebug.debug(params.toString());
                return panel;
            }
        });
        Thread panelInit = new Thread(panel.getThreadGroup(), new Runnable(){

            @Override
            public void run() {
                panel.createNewAppContext();
                PluginDebug.debug("X and Y are: " + params.getWidth() + " " + params.getHeight());
                panel.setAppletViewerFrame((SplashController)PluginAppletViewer.framePanel(identifier, handle, params.getWidth(), params.getHeight(), panel));
                panel.init();
                PluginAppletPanelFactory.this.initEventQueue((AppletPanel)panel);
            }
        }, "NetXPanel initializer");
        panelInit.start();
        try {
            panelInit.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        PluginAppletPanelFactory.setAppletViewerSize((AppletPanel)panel, params.getWidth(), params.getHeight());
        PluginAppletViewer.waitForAppletInit(panel);
        Applet a = panel.getApplet();
        if (a == null) {
            streamhandler.write("instance " + identifier + " reference " + -1 + " fatalError: " + "Initialization timed out");
            return null;
        }
        PluginDebug.debug("Applet ", a.getClass(), " initialized");
        streamhandler.write("instance " + identifier + " reference 0 initialized");
        panel.removeSplash();
        AppletSecurityContextManager.getSecurityContext(0).associateSrc(panel.getAppletClassLoader(), doc);
        AppletSecurityContextManager.getSecurityContext(0).associateInstance(identifier, panel.getAppletClassLoader());
        return panel;
    }

    private static void setAppletViewerSize(final AppletPanel panel, final int width, final int height) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    panel.getParent().setSize(width, height);
                }
            });
        }
        catch (InvocationTargetException e) {
            PluginDebug.debug("Unable to resize panel: ");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            PluginDebug.debug("Unable to resize panel: ");
            e.printStackTrace();
        }
    }

    private void initEventQueue(AppletPanel panel) {
        PrivilegedAction<String> pa = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("appletviewer.send.event");
            }
        };
        String eventList = AccessController.doPrivileged(pa);
        if (eventList == null) {
            panel.sendEvent(1);
            panel.sendEvent(2);
            panel.sendEvent(3);
        } else {
            String[] events;
            for (String event : events = eventList.split(",")) {
                PluginDebug.debug("Adding event to queue: ", event);
                if ("dispose".equals(event)) {
                    panel.sendEvent(0);
                    continue;
                }
                if ("load".equals(event)) {
                    panel.sendEvent(1);
                    continue;
                }
                if ("init".equals(event)) {
                    panel.sendEvent(2);
                    continue;
                }
                if ("start".equals(event)) {
                    panel.sendEvent(3);
                    continue;
                }
                if ("stop".equals(event)) {
                    panel.sendEvent(4);
                    continue;
                }
                if ("destroy".equals(event)) {
                    panel.sendEvent(5);
                    continue;
                }
                if ("quit".equals(event)) {
                    panel.sendEvent(6);
                    continue;
                }
                if ("error".equals(event)) {
                    panel.sendEvent(7);
                    continue;
                }
                PluginDebug.debug("Unrecognized event name: ", event);
            }
            while (!panel.emptyEventQueue()) {
            }
        }
    }
}

