#!/bin/sh
echo 'name: text
version: 0.11.3.1
id: text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812

license: BSD3
copyright: 2009-2011 Bryan O'\''Sullivan, 2008-2009 Tom Harper
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability:
homepage: https://github.com/bos/text
package-url:
synopsis: An efficient packed Unicode text type.
description:  
             .
             An efficient packed, immutable Unicode text type (both strict and
             lazy), with a powerful loop fusion optimization framework.
             .
             The '\''Text'\'' type represents Unicode character strings, in a time and
             space-efficient manner. This package provides text processing
             capabilities that are optimized for performance critical use, both
             in terms of large data quantities and high speed.
             .
             The '\''Text'\'' type provides character-encoding, type-safe case
             conversion via whole-string case conversion functions. It also
             provides a range of functions for converting '\''Text'\'' values to and from
             '\''ByteStrings'\'', using several standard encodings.
             .
             Efficient locale-sensitive support for text IO is also supported.
             .
             These modules are intended to be imported qualified, to avoid name
             clashes with Prelude functions, e.g.
             .
             > import qualified Data.Text as T
             .
             To use an extended and very rich family of functions for working
             with Unicode text (including normalization, regular expressions,
             non-standard encodings, text breaking, and locales), see
             the @text-icu@ package:
             <http://hackage.haskell.org/package/text-icu>
             .
             &#8212;&#8212; RELEASE NOTES &#8212;&#8212;
             .
             Changes in 0.11.2.0:
             .
             * String literals are now converted directly from the format in
             which GHC stores them into '\''Text'\'', without an intermediate
             transformation through '\''String'\'', and without inlining of
             conversion code at each site where a string literal is declared.
             .
category: Data, Text
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-text
exposed: True
exposed-modules: Data.Text Data.Text.Array Data.Text.Encoding
                 Data.Text.Encoding.Error Data.Text.Foreign Data.Text.IO
                 Data.Text.Internal Data.Text.Lazy Data.Text.Lazy.Builder
                 Data.Text.Lazy.Builder.Int Data.Text.Lazy.Builder.RealFloat
                 Data.Text.Lazy.Encoding Data.Text.Lazy.IO Data.Text.Lazy.Internal
                 Data.Text.Lazy.Read Data.Text.Read Data.Text.Unsafe
hidden-modules: Data.Text.Encoding.Fusion
                Data.Text.Encoding.Fusion.Common Data.Text.Encoding.Utf16
                Data.Text.Encoding.Utf32 Data.Text.Encoding.Utf8 Data.Text.Fusion
                Data.Text.Fusion.CaseMapping Data.Text.Fusion.Common
                Data.Text.Fusion.Internal Data.Text.Fusion.Size
                Data.Text.IO.Internal Data.Text.Lazy.Builder.Functions
                Data.Text.Lazy.Builder.Int.Digits Data.Text.Lazy.Builder.Internal
                Data.Text.Lazy.Builder.RealFloat.Functions
                Data.Text.Lazy.Encoding.Fusion Data.Text.Lazy.Fusion
                Data.Text.Lazy.Search Data.Text.Private Data.Text.Search
                Data.Text.Unsafe.Base Data.Text.UnsafeChar Data.Text.UnsafeShift
                Data.Text.Util
trusted: False
import-dirs: /usr/local/lib/ghc/text-0.11.3.1
library-dirs: /usr/local/lib/ghc/text-0.11.3.1
hs-libraries: HStext-0.11.3.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         deepseq-1.3.0.1-5cc4cd89bdc2e8f6db1833d95ec36926
         ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
         integer-gmp-0.5.0.0-2f15426f5b53fe4c6490832f9b20d8d7
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-text-0.11.3.1/html/text.haddock
haddock-html: /usr/local/share/doc/hs-text-0.11.3.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
