#!/bin/sh
echo 'name: heist
version: 0.12.0
id: heist-0.12.0-f7d773500ed4670c319cb795ee40e448

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: An Haskell template system supporting both HTML5 and XML.
description: Heist is a powerful template system that supports both HTML5 and XML.
             Some of Heist'\''s features are:
             .
             * Designer-friendly HTML5 (or XML) syntax
             .
             * Templates can be reloaded to make changes visible without recompiling
             your Haskell code
             .
             * Enforces near-perfect separation of business logic and view
             .
             * Powerful abstraction primitives allowing you to eliminate repetition
             .
             * Easy creation of domain-specific markup languages
             .
             * Built-in support for including JSON and Markdown content in templates
             .
             * Simple mechanism for designer-specified template caching
             .
             * Optional merging of multiple \<head\> tags defined anywhere in the
             document
category: Web, Snap
author: Doug Beardsley, Gregory Collins
pkgpath: textproc/hs-heist
exposed: True
exposed-modules: Heist Heist.Compiled Heist.Interpreted
                 Heist.Splices Heist.Splices.Apply Heist.Splices.Bind
                 Heist.Splices.BindStrict Heist.Splices.Cache Heist.Splices.Html
                 Heist.Splices.Ignore Heist.Splices.Json Heist.Splices.Markdown
                 Heist.TemplateDirectory
hidden-modules: Data.HeterogeneousEnvironment Heist.Common
                Heist.Compiled.Internal Heist.Interpreted.Internal Heist.Types
trusted: False
import-dirs: /usr/local/lib/ghc/heist-0.12.0
library-dirs: /usr/local/lib/ghc/heist-0.12.0
hs-libraries: HSheist-0.12.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-transformers-0.3.0.0-00f5ba39422294066c7f13d4ef6c89a7
         aeson-0.6.2.1-92173c75149e34c3bea9cafc379c1c76
         attoparsec-0.10.4.0-d9fd97cfc1a1748b3cde35adf7fd233b
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         blaze-builder-0.3.1.1-71a2ae53eb5daf9e6673db8b47b3b6b5
         blaze-html-0.6.1.1-74b89d78fdb27cee6a6592a1caa310c1
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         directory-tree-0.11.0-5c20bbe86d621a648706bf53701cb991
         dlist-0.5-6480552fbf191185cc86167748682e90
         errors-1.4.2-34975bd2e1590962642c5f29c9201c34
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         hashable-1.1.2.5-e0f2541518f84d3123a819112b4ffe20
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         process-1.1.0.2-76e05340eb66705981411022731ca84a
         random-1.0.1.1-49dee13e6169a73481e9624e99220b78
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
         unordered-containers-0.2.3.0-c7952fe8bed178bdf8ed4d090730c9da
         vector-0.10.0.1-869166d5d49db46ce6c328ea5f8defbf
         xmlhtml-0.2.1-658d8ec37c0651e1f661d3d92991944e
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-heist-0.12.0/html/heist.haddock
haddock-html: /usr/local/share/doc/hs-heist-0.12.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
