#!/bin/sh
echo 'name: hashed-storage
version: 0.5.10
id: hashed-storage-0.5.10-80be882f4dcacefd1ea32f3b81c265c3

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
synopsis: Hashed file storage support code.
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.10
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.10
hs-libraries: HShashed-storage-0.5.10
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         binary-0.5.1.1-313d93fcb82c25b3160f1d73103e143f
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         dataenc-0.14.0.5-53e97aa81238832bc61a10c7ff992b10
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         extensible-exceptions-0.1.1.4-255a395b3b026cb94b23754e1c372785
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         mmap-0.5.8-867b6ad07eb48ef9e7b327f980535c80
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         zlib-0.5.4.1-13ba81ac0d7e6f3bdf1ee5ddce4e9aab
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.10/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
