#!/bin/sh
echo 'name: Crypto
version: 4.2.5.1
id: Crypto-4.2.5.1-2d101004eecada558fbb8a6f3cc7428d

license: OtherLicense
copyright: Dominic Steinitz 2003 - 2007
maintainer: Caylee Hogg <caylee.hogg@gmail.com>
stability: Alpha
homepage:
package-url:
synopsis: Collects together existing Haskell cryptographic functions into a package
description: DES, Blowfish, AES, TEA, SHA1, MD5, RSA, BubbleBabble,
             Hexdump, Support for Word128, Word192 and Word256 and Beyond, PKCS5
             Padding, Various Encryption Modes e.g. Cipher Block Chaining all in one package,
             with HUnit and QuickCheck tests, and examples.
category: Cryptography, Codec
author: Dominic Steinitz
pkgpath: security/hs-crypto
exposed: True
exposed-modules: Codec.Binary.BubbleBabble Codec.Encryption.RSA
                 Codec.Encryption.RSA.EMEOAEP Codec.Encryption.RSA.MGF
                 Codec.Encryption.RSA.NumberTheory Codec.Encryption.DES
                 Codec.Encryption.AES Codec.Encryption.TEA Codec.Encryption.Blowfish
                 Codec.Encryption.Modes Codec.Encryption.Padding Codec.Text.Raw
                 Codec.Utils Data.Digest.MD5 Data.Digest.SHA1 Data.Digest.SHA2
                 Data.Digest.SHA224 Data.Digest.SHA256 Data.Digest.SHA384
                 Data.Digest.SHA512 Data.LargeWord Data.HMAC
hidden-modules: Codec.Encryption.BlowfishAux
                Codec.Encryption.DESAux Codec.Encryption.AESAux Data.Digest.MD5Aux
trusted: False
import-dirs: /usr/local/lib/ghc/Crypto-4.2.5.1
library-dirs: /usr/local/lib/ghc/Crypto-4.2.5.1
hs-libraries: HSCrypto-4.2.5.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.2-6e02ecc15e3cc5ab8ef10df50d05a1a9
         QuickCheck-2.6-3bc15ce636c5f5b25be7c5990f3b8a79
         array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         pretty-1.1.1.0-66181c695e6a2e173ba2088cf55cc396
         random-1.0.1.1-49dee13e6169a73481e9624e99220b78
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-Crypto-4.2.5.1/html/Crypto.haddock
haddock-html: /usr/local/share/doc/hs-Crypto-4.2.5.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
