#!/bin/sh
echo 'name: conduit
version: 1.0.7.1
id: conduit-1.0.7.1-c17bc1bf5262c504134f68ab9756fe65

license: MIT
copyright:
maintainer: michael@snoyman.com
stability:
homepage: http://github.com/snoyberg/conduit
package-url:
synopsis: Streaming data processing library.
description: @conduit@ is a solution to the streaming data problem, allowing for production, transformation, and consumption of streams of data in constant memory. It is an alternative to lazy I\/O which guarantees deterministic resource handling, and fits in the same general solution space as @enumerator@\/@iteratee@ and @pipes@. For a tutorial, please visit <https://haskell.fpcomplete.com/user/snoyberg/library-documentation/conduit-overview>.
             .
             Release history:
             .
             [1.0] Simplified the user-facing interface back to the Source, Sink, and Conduit types, with Producer and Consumer for generic code. Error messages have been simplified, and optional leftovers and upstream terminators have been removed from the external API. Some long-deprecated functions were finally removed.
             .
             [0.5] The internals of the package are now separated to the .Internal module, leaving only the higher-level interface in the advertised API. Internally, switched to a @Leftover@ constructor and slightly tweaked the finalization semantics.
             .
             [0.4] Inspired by the design of the pipes package: we now have a single unified type underlying @Source@, @Sink@, and @Conduit@. This type is named @Pipe@. There are type synonyms provided for the other three types. Additionally, @BufferedSource@ is no longer provided. Instead, the connect-and-resume operator, @$$+@, can be used for the same purpose.
             .
             [0.3] ResourceT has been greatly simplified, specialized for IO, and moved into a separate package. Instead of hard-coding ResourceT into the conduit datatypes, they can now live around any monad. The Conduit datatype has been enhanced to better allow generation of streaming output. The SourceResult, SinkResult, and ConduitResult datatypes have been removed entirely.
             .
             [0.2] Instead of storing state in mutable variables, we now use CPS. A @Source@ returns the next @Source@, and likewise for @Sink@s and @Conduit@s. Not only does this take better advantage of GHC\'\''s optimizations (about a 20% speedup), but it allows some operations to have a reduction in algorithmic complexity from exponential to linear. This also allowed us to remove the @Prepared@ set of types. Also, the @State@ functions (e.g., @sinkState@) use better constructors for return types, avoiding the need for a dummy state on completion.
             .
             [0.1] @BufferedSource@ is now an abstract type, and has a much more efficient internal representation. The result was a 41% speedup on microbenchmarks (note: do not expect speedups anywhere near that in real usage). In general, we are moving towards @BufferedSource@ being a specific tool used internally as needed, but using @Source@ for all external APIs.
             .
             [0.0] Initial release.
category: Data, Conduit
author: Michael Snoyman
pkgpath: devel/hs-conduit
exposed: True
exposed-modules: Data.Conduit Data.Conduit.Binary Data.Conduit.Text
                 Data.Conduit.List Data.Conduit.Lazy Data.Conduit.Internal
                 Data.Conduit.Util
hidden-modules: System.PosixFile
trusted: False
import-dirs: /usr/local/lib/ghc/conduit-1.0.7.1
library-dirs: /usr/local/lib/ghc/conduit-1.0.7.1
hs-libraries: HSconduit-1.0.7.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         lifted-base-0.1.1.1-522927d22628737efa7d6e11257afa0c
         mmorph-1.0.0-20a6abb10acd5d213e6c72450f873a5d
         monad-control-0.3.1.4-82c4d425731905798d4e75256cfd14ef
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         resourcet-0.4.6-d029b063dce9e86af3d5a18cfe7f73c0
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
         transformers-base-0.4.1-da9c4a03c3accfcef7f09e5e6d753fad
         void-0.6.1-48989bd2fa47b96a3f7c31acb5249253
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-conduit-1.0.7.1/html/conduit.haddock
haddock-html: /usr/local/share/doc/hs-conduit-1.0.7.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
