#!/bin/sh
echo 'name: blaze-builder
version: 0.3.1.1
id: blaze-builder-0.3.1.1-71a2ae53eb5daf9e6673db8b47b3b6b5

license: BSD3
copyright: 2010 Simon Meier
           2010 Jasper Van der Jeugt
maintainer: Simon Meier <iridcode@gmail.com>
stability: Experimental
homepage: http://github.com/meiersi/blaze-builder
package-url:
synopsis: Efficient buffered output.
description: This library provides an abstraction of buffered output of
             byte streams and several convenience functions to exploit
             it. For example, it allows to efficiently serialize
             Haskell values to lazy bytestrings with a large average
             chunk size. The large average chunk size allows to make
             good use of cache prefetching in later processing steps
             (e.g. compression) and reduces the sytem call overhead
             when writing the resulting lazy bytestring to a file or
             sending it over the network.
category: Data
author: Jasper Van der Jeugt, Simon Meier
pkgpath: devel/hs-blaze-builder
exposed: True
exposed-modules: Blaze.ByteString.Builder
                 Blaze.ByteString.Builder.Int Blaze.ByteString.Builder.Word
                 Blaze.ByteString.Builder.ByteString
                 Blaze.ByteString.Builder.Char.Utf8 Blaze.ByteString.Builder.Char8
                 Blaze.ByteString.Builder.Html.Utf8 Blaze.ByteString.Builder.HTTP
                 Blaze.ByteString.Builder.Internal
                 Blaze.ByteString.Builder.Internal.Write
                 Blaze.ByteString.Builder.Internal.Types
                 Blaze.ByteString.Builder.Internal.Buffer
hidden-modules: Blaze.ByteString.Builder.Internal.UncheckedShifts
trusted: False
import-dirs: /usr/local/lib/ghc/blaze-builder-0.3.1.1
library-dirs: /usr/local/lib/ghc/blaze-builder-0.3.1.1
hs-libraries: HSblaze-builder-0.3.1.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-blaze-builder-0.3.1.1/html/blaze-builder.haddock
haddock-html: /usr/local/share/doc/hs-blaze-builder-0.3.1.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
