#!/bin/sh
echo 'name: base-unicode-symbols
version: 0.2.2.4
id: base-unicode-symbols-0.2.2.4-ec1c787160bf91bc92b0b4f99c4199a9

license: BSD3
copyright: 2009–2011 Roel van Dijk <vandijk.roel@gmail.com>
maintainer: Roel van Dijk <vandijk.roel@gmail.com>
stability: provisional
homepage: http://haskell.org/haskellwiki/Unicode-symbols
package-url:
synopsis: Unicode alternatives for common functions and operators
description: This package defines new symbols for a number of functions,
             operators and types in the base package.
             .
             All symbols are documented with their actual definition and
             information regarding their Unicode code point. They should be
             completely interchangeable with their definitions.
             .
             For further Unicode goodness you can enable the @UnicodeSyntax@
             language extension \[1\]. This extension enables Unicode characters
             to be used to stand for certain ASCII character sequences,
             i.e. &#x2192; instead of @->@, &#x2200; instead of @forall@ and many
             others.
             .
             Original idea by P&#xE9;ter Divi&#xE1;nszky.
             .
             \[1\] <http://www.haskell.org/ghc/docs/latest/html/users_guide/syntax-extns.html#unicode-syntax>
category:
author: Roel van Dijk <vandijk.roel@gmail.com>
pkgpath: devel/hs-base-unicode-symbols
exposed: True
exposed-modules: Control.Category.Unicode
                 Control.Applicative.Unicode Control.Arrow.Unicode
                 Control.Monad.Unicode Data.Bool.Unicode Data.Eq.Unicode
                 Data.Foldable.Unicode Data.Function.Unicode Data.List.Unicode
                 Data.Monoid.Unicode Data.Ord.Unicode Prelude.Unicode
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/base-unicode-symbols-0.2.2.4
library-dirs: /usr/local/lib/ghc/base-unicode-symbols-0.2.2.4
hs-libraries: HSbase-unicode-symbols-0.2.2.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-base-unicode-symbols-0.2.2.4/html/base-unicode-symbols.haddock
haddock-html: /usr/local/share/doc/hs-base-unicode-symbols-0.2.2.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
