#!/bin/sh
echo 'name: QuickCheck
version: 2.6
id: QuickCheck-2.6-3bc15ce636c5f5b25be7c5990f3b8a79

license: BSD3
copyright: 2000-2012 Koen Claessen, 2006-2008 Björn Bringert, 2009-2012 Nick Smallbone
maintainer: QuickCheck developers <quickcheck@projects.haskell.org>
stability:
homepage: http://code.haskell.org/QuickCheck
package-url:
synopsis: Automatic testing of Haskell programs
description: QuickCheck is a library for random testing of program properties.
             .
             The programmer provides a specification of the program, in
             the form of properties which functions should satisfy, and
             QuickCheck then tests that the properties hold in a large number
             of randomly generated cases.
             .
             Specifications are expressed in
             Haskell, using combinators defined in the QuickCheck library.
             QuickCheck provides combinators to define properties, observe
             the distribution of test data, and define test
             data generators.
category: Testing
author: Koen Claessen <koen@chalmers.se>
pkgpath: devel/hs-QuickCheck
exposed: True
exposed-modules: Test.QuickCheck.All Test.QuickCheck.Function
                 Test.QuickCheck Test.QuickCheck.Arbitrary Test.QuickCheck.Gen
                 Test.QuickCheck.Monadic Test.QuickCheck.Modifiers
                 Test.QuickCheck.Property Test.QuickCheck.Test Test.QuickCheck.Text
                 Test.QuickCheck.Poly Test.QuickCheck.State
hidden-modules: Test.QuickCheck.Exception
trusted: False
import-dirs: /usr/local/lib/ghc/QuickCheck-2.6
library-dirs: /usr/local/lib/ghc/QuickCheck-2.6
hs-libraries: HSQuickCheck-2.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         random-1.0.1.1-49dee13e6169a73481e9624e99220b78
         template-haskell-2.8.0.0-2f3447bb22ecbbb93fd4d823f6841241
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-QuickCheck-2.6/html/QuickCheck.haddock
haddock-html: /usr/local/share/doc/hs-QuickCheck-2.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
