/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class SslRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = -8310631444933958385L;
    private String[] enabledCipherSuites = this.getProp("javax.rmi.ssl.client.enabledCipherSuites");
    private String[] enabledProtocols = this.getProp("javax.rmi.ssl.client.enabledProtocols");
    private static SSLSocketFactory socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    private String[] getProp(String p) {
        String o;
        try {
            o = System.getProperty(p);
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (o == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(o, ",");
        int n = st.countTokens();
        if (n < 1) {
            return null;
        }
        String[] strs = new String[n];
        int i = 0;
        while (i < n) {
            strs[i] = st.nextToken().trim();
            ++i;
        }
        return strs;
    }

    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)socketFactory.createSocket(host, port);
        if (this.enabledCipherSuites != null) {
            socket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            socket.setEnabledProtocols(this.enabledProtocols);
        }
        return socket;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SslRMIClientSocketFactory)) {
            return false;
        }
        SslRMIClientSocketFactory s = (SslRMIClientSocketFactory)obj;
        if (!SslRMIServerSocketFactory.cmpStrArray(this.enabledCipherSuites, s.enabledCipherSuites)) {
            return false;
        }
        return SslRMIServerSocketFactory.cmpStrArray(this.enabledProtocols, s.enabledProtocols);
    }

    public int hashCode() {
        int i;
        int hash = 0;
        if (this.enabledCipherSuites != null) {
            i = 0;
            while (i < this.enabledCipherSuites.length) {
                hash ^= this.enabledCipherSuites[i].hashCode();
                ++i;
            }
        }
        if (this.enabledProtocols != null) {
            i = 0;
            while (i < this.enabledProtocols.length) {
                hash ^= this.enabledProtocols[i].hashCode();
                ++i;
            }
        }
        return hash;
    }
}

