/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import java.io.IOException;
import java.io.Reader;

public class UnicodeReader {
    final Reader in;

    UnicodeReader(Reader in) {
        this.in = in;
    }

    public void mark(int limit) throws IOException {
        this.in.mark(limit * 2);
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret == -1) {
            return ret;
        }
        if (ret >= 55296 && ret < 56320) {
            int low = this.in.read();
            if (low < 56320) throw new IOException("unpaired surrogate: U+" + Integer.toHexString(ret));
            if (low >= 57344) throw new IOException("unpaired surrogate: U+" + Integer.toHexString(ret));
            return Character.toCodePoint((char)ret, (char)low);
        }
        if (ret < 56320) return ret;
        if (ret >= 57344) return ret;
        throw new IOException("unpaired surrogate: U+" + Integer.toHexString(ret));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(int[] buf, int off, int len) throws IOException {
        char c;
        if (len == 0) {
            return 0;
        }
        char[] b2 = new char[len];
        int ret = this.in.read(b2, 0, len);
        if (ret <= 0) {
            return ret;
        }
        int l = ret - 1;
        int i = 0;
        int j = off;
        while (i < l) {
            c = b2[i];
            if (c >= '\ud800' && c < '\udc00') {
                char d = b2[i + 1];
                if (d < '\udc00' || d >= '\ue000') throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                buf[j++] = Character.toCodePoint(c, d);
                ++i;
            } else {
                if (c >= '\udc00' && c < '\ue000') {
                    throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                }
                buf[j++] = c;
            }
            ++i;
        }
        if (i != l) return j;
        c = b2[l];
        if (c >= '\ud800' && c < '\udc00') {
            int low = this.in.read();
            if (low < 56320 || low >= 57344) throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
            buf[j++] = Character.toCodePoint(c, (char)low);
            return j;
        }
        if (c >= '\udc00' && c < '\ue000') {
            throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
        }
        buf[j++] = c;
        return j;
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] toCodePointArray(String text) throws IOException {
        char[] b2 = text.toCharArray();
        int[] buf = new int[b2.length];
        if (b2.length <= 0) return buf;
        int l = b2.length - 1;
        int i = 0;
        int j = 0;
        while (i < l) {
            char c = b2[i];
            if (c >= '\ud800' && c < '\udc00') {
                char d = b2[i + 1];
                if (d < '\udc00') throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                if (d >= '\ue000') throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                buf[j++] = Character.toCodePoint(c, d);
                ++i;
            } else {
                if (c >= '\udc00' && c < '\ue000') {
                    throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                }
                buf[j++] = c;
            }
            ++i;
        }
        if (i != l) return buf;
        buf[j++] = b2[l];
        if (j >= buf.length) return buf;
        int[] buf2 = new int[j];
        System.arraycopy(buf, 0, buf2, 0, j);
        return buf2;
    }
}

