/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.gcj.runtime.PersistentByteMap;
import gnu.gcj.runtime.SharedLibHelper;
import gnu.java.security.hash.MD5;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.BufferUnderflowException;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;

final class VMCompiler {
    public static boolean useCompiler = true;
    public static final boolean canUseCompiler;
    public static String gcjJitCompiler;
    public static String gcjJitCompilerOptions;
    public static String gcjJitTmpdir;
    private static WeakHashMap sharedHelperMap;
    private static Vector precompiledMapFiles;
    private static final MD5 md5Digest;

    static {
        sharedHelperMap = new WeakHashMap();
        md5Digest = new MD5();
        gcjJitCompiler = System.getProperty("gnu.gcj.jit.compiler");
        if (gcjJitCompiler == null) {
            canUseCompiler = false;
        } else {
            gcjJitCompilerOptions = System.getProperty("gnu.gcj.jit.options", "-g");
            gcjJitTmpdir = System.getProperty("gnu.gcj.jit.cachedir");
            canUseCompiler = gcjJitTmpdir != null;
        }
        String prop = System.getProperty("gnu.gcj.precompiled.db.path");
        if (prop != null) {
            precompiledMapFiles = new Vector();
            StringTokenizer st = new StringTokenizer(prop, System.getProperty("path.separator", ":"));
            while (st.hasMoreElements()) {
                String e = st.nextToken();
                try {
                    PersistentByteMap map = new PersistentByteMap(e, PersistentByteMap.AccessMode.READ_ONLY);
                    precompiledMapFiles.add(map);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IOException iOException) {
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
        }
    }

    public static boolean precompiles() {
        return canUseCompiler & useCompiler;
    }

    private VMCompiler() {
    }

    private static Class loadSharedLibrary(ClassLoader loader, String fileName, ProtectionDomain domain, String className) {
        Class c = null;
        SharedLibHelper helper = SharedLibHelper.findHelper(loader, fileName, domain.getCodeSource(), domain, false);
        c = helper.findClass(className);
        if (c != null) {
            HashSet<SharedLibHelper> hs = (HashSet<SharedLibHelper>)sharedHelperMap.get(loader);
            if (hs == null) {
                hs = new HashSet<SharedLibHelper>();
                sharedHelperMap.put(loader, hs);
            }
            hs.add(helper);
        }
        return c;
    }

    public static Class compileClass(ClassLoader loader, String name, byte[] data, int offset, int len, ProtectionDomain domain) {
        File soFile;
        block19: {
            File classFile;
            block18: {
                byte[] digest;
                if (precompiledMapFiles == null && !VMCompiler.precompiles()) {
                    return null;
                }
                try {
                    MD5 md = (MD5)md5Digest.clone();
                    md.update(data);
                    digest = md.digest();
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
                if (precompiledMapFiles != null) {
                    try {
                        Enumeration elements = precompiledMapFiles.elements();
                        while (elements.hasMoreElements()) {
                            PersistentByteMap map = (PersistentByteMap)elements.nextElement();
                            byte[] soName = map.get(digest);
                            if (soName == null) continue;
                            return VMCompiler.loadSharedLibrary(loader, new String(soName), domain, name);
                        }
                    }
                    catch (Exception exception) {
                    }
                    catch (UnknownError unknownError) {}
                }
                if (!VMCompiler.precompiles()) {
                    return null;
                }
                StringBuffer hexBytes = new StringBuffer(gcjJitTmpdir);
                hexBytes.append(File.separatorChar);
                int digestLength = digest.length;
                int i = 0;
                while (i < digestLength) {
                    int v = digest[i] & 0xFF;
                    if (v < 16) {
                        hexBytes.append('0');
                    }
                    hexBytes.append(Integer.toHexString(v));
                    ++i;
                }
                soFile = new File(hexBytes + ".so");
                if (soFile.isFile()) {
                    return VMCompiler.loadSharedLibrary(loader, soFile.toString(), domain, name);
                }
                classFile = new File(hexBytes + ".class");
                classFile.delete();
                if (classFile.createNewFile()) break block18;
                return null;
            }
            try {
                int bytesRead;
                FileOutputStream f = new FileOutputStream(classFile);
                f.write(data, offset, len);
                StringBuffer command = new StringBuffer(gcjJitCompiler);
                command.append(" ");
                command.append(classFile);
                command.append(" ");
                command.append(gcjJitCompilerOptions);
                command.append(" -findirect-dispatch -fjni -shared -fPIC -o ");
                command.append(soFile);
                Process p = Runtime.getRuntime().exec(command.toString());
                StringBuffer err = new StringBuffer();
                InputStreamReader stderr = new InputStreamReader(p.getErrorStream());
                char[] inBuf = new char[500];
                while ((bytesRead = stderr.read(inBuf)) != -1) {
                    err.append(inBuf, 0, bytesRead);
                }
                if (p.waitFor() == 0) break block19;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return VMCompiler.loadSharedLibrary(loader, soFile.toString(), domain, name);
    }

    public static boolean compileClass(Class oneClass) {
        return false;
    }

    public static boolean compileClasses(String classNames) {
        return false;
    }

    public static Object command(Object arg) {
        return null;
    }

    public static void enable() {
        useCompiler = true;
    }

    public static void disable() {
        useCompiler = false;
    }
}

