from __future__ import division
from __future__ import print_function
from __future__ import absolute_import
from __future__ import unicode_literals

import hashlib
import fs_uae_launcher.fsui as fsui
from .Archive import Archive
from .ROMManager import ROMManager

import os.path

class ChecksumTool():

    TOO_BIG = 64*1024*1024
    ZERO_SHA1 = "da39a3ee5e6b4b0d3255bfef95601890afd80709"

    def __init__(self, parent):
        self.parent = parent
        #fsui.Window.__init__(self, parent, "Checksumming")
        #self.layout = fsui.VerticalLayout()
        #
        #label = fsui.HeadingLabel(self, "Checksumming file...")
        #self.layout.add(label, fill=True)
        #self.layout.add_spacer(6)
        ##self.center_on_parent()

    def checksum(self, path):
        # first check that we even want to checksum
        size = os.path.getsize(path)
        if size >= ChecksumTool.TOO_BIG:
            print("checksumtool: not checksumming large file: %s" % path)
            return ""
        elif size == 0:
            # either a real 0-byte file or a device node on a BSD           
            # system (could be large). To reliably get the size we could    
            # use ioctl, but we simply return the checksum for a 0-byte     
            # file anyway                                               
            print("checksumtool: not checksumming zero "
                    "sized file/device: %s" % path)
            return ChecksumTool.ZERO_SHA1

        print("checksumtool: checksumming ", repr(path))
        archive = Archive(path)
        s = hashlib.sha1()
        f = archive.open(path)
        while True:
            data = f.read(65536)
            if not data:
                break
            s.update(data)
        return s.hexdigest()

    def checksum_rom(self, path):
        print("checksum_rom", repr(path))
        archive = Archive(path)
        return ROMManager.decrypt_archive_rom(archive, path)["sha1"]
