/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.VersionedIdentifiersFilter;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class UpdateCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private String featureId;
    private IFeature currentFeature;

    public UpdateCommand(String featureId, String verifyOnly) throws Exception {
        this(featureId, null, verifyOnly);
    }

    public UpdateCommand(String featureId, String version, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            this.featureId = featureId;
            if (featureId != null) {
                this.targetSite = UpdateUtils.getSiteWithFeature(this.getConfiguration(), featureId);
                if (this.targetSite == null) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noConfigSiteForFeature, (Object[])new String[]{featureId}));
                }
                IFeature[] currentFeatures = UpdateUtils.searchSite(featureId, this.targetSite, true);
                if (currentFeatures == null || currentFeatures.length == 0) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noFeatures3, (Object[])new String[]{featureId}));
                }
                this.currentFeature = currentFeatures[0];
            } else {
                IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();
                int i = 0;
                while (i < sites.length) {
                    if (sites[i].isProductSite()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.currentFeature == null) {
                this.searchRequest = UpdateUtils.createNewUpdatesRequest(null);
            } else {
                this.searchRequest = UpdateUtils.createNewUpdatesRequest(new IFeature[]{this.currentFeature});
                if (version != null) {
                    this.searchRequest.addFilter(new VersionedIdentifiersFilter(new VersionedIdentifier[]{new VersionedIdentifier(featureId, version)}));
                }
            }
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
        }
        catch (CoreException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(IProgressMonitor monitor) {
        IInstallFeatureOperation[] operations;
        IStatus status;
        block16: {
            block17: {
                block15: {
                    status = OperationsManager.getValidator().validatePlatformConfigValid();
                    if (status != null) {
                        UpdateCore.log(status);
                        return false;
                    }
                    monitor.beginTask(Messages.Standalone_updating, 4);
                    this.searchRequest.performSearch(this.collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    operations = this.collector.getOperations();
                    if (operations != null && operations.length != 0) break block15;
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(Utilities.newCoreException(NLS.bind((String)Messages.Standalone_noUpdate, (Object[])new String[]{this.featureId}), null));
                    return false;
                }
                ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts(operations, this.getConfiguration());
                if (conflicts != null) {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(Utilities.newCoreException(Messages.Standalone_duplicate, null));
                    return false;
                }
                if (!this.isVerifyOnly()) break block16;
                status = OperationsManager.getValidator().validatePendingChanges(operations);
                if (status == null || status.getCode() != 4) break block17;
                throw new CoreException(status);
            }
            return true;
        }
        try {
            try {
                IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
                try {
                    installOperation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 3), this);
                    System.out.println(String.valueOf(Messages.Standalone_feature) + this.featureId + " " + Messages.Standalone_updated);
                    return true;
                }
                catch (Exception e) {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(Utilities.newCoreException(NLS.bind((String)Messages.Standalone_noUpdate, (Object[])new String[]{this.featureId}), e));
                    return false;
                }
            }
            catch (CoreException ce) {
                status = ce.getStatus();
                if (status != null && status.getCode() == 42) {
                    System.out.println(Messages.Standalone_connection);
                    return false;
                }
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(ce);
                return false;
            }
            catch (OperationCanceledException operationCanceledException) {
                return true;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            monitor.done();
        }
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            IInstallFeatureOperation op = OperationsManager.getOperationFactory().createInstallOperation(null, feature, null, null, null);
            IConfiguredSite site = UpdateUtils.getDefaultTargetSite(UpdateCommand.this.getConfiguration(), op);
            if (site == null) {
                site = UpdateUtils.getAffinitySite(UpdateCommand.this.getConfiguration(), feature);
            }
            if (site == null) {
                site = UpdateCommand.this.targetSite;
            }
            op.setTargetSite(site);
            this.operations.add(op);
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] opsArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(opsArray);
            return opsArray;
        }
    }
}

