/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ShowInNavigatorAction
extends SelectionProviderAction {
    private IWorkbenchPage page;

    public ShowInNavigatorAction(IWorkbenchPage page, ISelectionProvider viewer) {
        super(viewer, ResourceNavigatorMessages.ShowInNavigator_text);
        Assert.isNotNull((Object)page);
        this.page = page;
        this.setDescription(ResourceNavigatorMessages.ShowInNavigator_toolTip);
        page.getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.show_in_navigator_action_context");
    }

    List getResources(IStructuredSelection selection) {
        ArrayList v = new ArrayList();
        for (Object o : selection) {
            IResource resource;
            if (o instanceof IResource) {
                v.add(o);
                continue;
            }
            if (o instanceof IMarker) {
                resource = ((IMarker)o).getResource();
                v.add(resource);
                continue;
            }
            if (!(o instanceof IAdaptable) || (resource = (IResource)((IAdaptable)o).getAdapter(IResource.class)) == null) continue;
            v.add(resource);
        }
        return v;
    }

    public void run() {
        List v = this.getResources(this.getStructuredSelection());
        if (v.isEmpty()) {
            return;
        }
        try {
            IViewPart view = this.page.showView("org.eclipse.ui.views.ResourceNavigator");
            if (view instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection(v);
                ((ISetSelectionTarget)view).selectReveal((ISelection)selection);
            }
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)ResourceNavigatorMessages.ShowInNavigator_errorMessage, (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!this.getResources(selection).isEmpty());
    }
}

