/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.filesystem.local.Convert;
import org.eclipse.osgi.util.NLS;

abstract class LocalFileNatives {
    private static boolean hasNatives = false;
    private static boolean isUnicode = false;
    private static final String LIBRARY_NAME = "localfile_1_0_0";

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            hasNatives = true;
            isUnicode = LocalFileNatives.internalIsUnicode();
        }
        catch (UnsatisfiedLinkError e) {
            LocalFileNatives.logMissingNativeLibrary(e);
        }
    }

    LocalFileNatives() {
    }

    public static boolean copyAttributes(String source, String destination, boolean copyLastModified) {
        if (hasNatives) {
            return isUnicode ? LocalFileNatives.internalCopyAttributesW(source.toCharArray(), destination.toCharArray(), copyLastModified) : LocalFileNatives.internalCopyAttributes(Convert.toPlatformBytes(source), Convert.toPlatformBytes(destination), copyLastModified);
        }
        return false;
    }

    public static FileInfo fetchFileInfo(String fileName) {
        FileInfo info = new FileInfo();
        if (isUnicode) {
            LocalFileNatives.internalGetFileInfoW(fileName.toCharArray(), info);
        } else {
            LocalFileNatives.internalGetFileInfo(Convert.toPlatformBytes(fileName), info);
        }
        return info;
    }

    private static final native boolean internalCopyAttributes(byte[] var0, byte[] var1, boolean var2);

    private static final native boolean internalCopyAttributesW(char[] var0, char[] var1, boolean var2);

    private static final native boolean internalGetFileInfo(byte[] var0, IFileInfo var1);

    private static final native boolean internalGetFileInfoW(char[] var0, IFileInfo var1);

    private static final native boolean internalIsUnicode();

    private static final native boolean internalSetFileInfo(byte[] var0, IFileInfo var1);

    private static final native boolean internalSetFileInfoW(char[] var0, IFileInfo var1, int var2);

    private static void logMissingNativeLibrary(UnsatisfiedLinkError e) {
        String libName = System.mapLibraryName(LIBRARY_NAME);
        String message = NLS.bind((String)Messages.couldNotLoadLibrary, (Object)libName);
        Policy.log(1, message);
    }

    public static void setFileInfo(String fileName, IFileInfo info, int options) {
        if (isUnicode) {
            LocalFileNatives.internalSetFileInfoW(fileName.toCharArray(), info, options);
        } else {
            LocalFileNatives.internalSetFileInfo(Convert.toPlatformBytes(fileName), info);
        }
    }

    public static boolean usingNatives() {
        return hasNatives;
    }
}

