/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.JavaIndenter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.TextEditorAction;

public class IndentAction
extends TextEditorAction {
    private int fCaretOffset;
    private final boolean fIsTabAction;

    public IndentAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean isTabAction) {
        super(bundle, prefix, editor);
        this.fIsTabAction = isTabAction;
    }

    public void run() {
        if (!this.isEnabled() || !this.validateEditorInputState()) {
            return;
        }
        ITextSelection selection = this.getSelection();
        final IDocument document = this.getDocument();
        if (document != null) {
            int nLines;
            int firstLine;
            final int offset = selection.getOffset();
            final int length = selection.getLength();
            final Position end = new Position(offset + length);
            this.fCaretOffset = -1;
            try {
                document.addPosition(end);
                firstLine = document.getLineOfOffset(offset);
                int minusOne = length == 0 ? 0 : 1;
                nLines = document.getLineOfOffset(offset + length - minusOne) - firstLine + 1;
            }
            catch (BadLocationException e) {
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "", (Throwable)e));
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    IRewriteTarget target = (IRewriteTarget)IndentAction.this.getTextEditor().getAdapter(IRewriteTarget.class);
                    if (target != null) {
                        target.beginCompoundChange();
                    }
                    try {
                        try {
                            int newLength;
                            int newOffset;
                            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
                            JavaIndenter indenter = new JavaIndenter(document, scanner, IndentAction.this.getJavaProject());
                            boolean multiLine = nLines > 1;
                            boolean hasChanged = false;
                            int i = 0;
                            while (i < nLines) {
                                hasChanged |= IndentAction.this.indentLine(document, firstLine + i, offset, indenter, scanner, multiLine);
                                ++i;
                            }
                            if (!IndentAction.this.fIsTabAction && multiLine) {
                                newOffset = offset;
                                newLength = end.getOffset() - offset;
                            } else {
                                newOffset = IndentAction.this.fCaretOffset;
                                newLength = 0;
                            }
                            if (newOffset != -1 && (hasChanged || newOffset != offset || newLength != length)) {
                                IndentAction.this.selectAndReveal(newOffset, newLength);
                            }
                            document.removePosition(end);
                        }
                        catch (BadLocationException e) {
                            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "ConcurrentModification in IndentAction", (Throwable)e));
                        }
                    }
                    finally {
                        if (target != null) {
                            target.endCompoundChange();
                        }
                    }
                }
            };
            if (nLines > 50) {
                Display display = this.getTextEditor().getEditorSite().getWorkbenchWindow().getShell().getDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void selectAndReveal(int newOffset, int newLength) {
        Assert.isTrue((newOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((newLength >= 0 ? 1 : 0) != 0);
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof JavaEditor) {
            ISourceViewer viewer = ((JavaEditor)editor).getViewer();
            if (viewer != null) {
                viewer.setSelectedRange(newOffset, newLength);
            }
        } else {
            this.getTextEditor().selectAndReveal(newOffset, newLength);
        }
    }

    private boolean indentLine(IDocument document, int line, int caret, JavaIndenter indenter, JavaHeuristicScanner scanner, boolean multiLine) throws BadLocationException {
        int lineLength;
        int end;
        int offset;
        IRegion currentLine = document.getLineInformation(line);
        int wsStart = offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
            ITypedRegion startingPartition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)false);
            String type = partition.getType();
            if (type.equals("__java_javadoc") || type.equals("__java_multiline_comment")) {
                indent = this.computeJavadocIndent(document, line, scanner, startingPartition);
            } else if (!this.fIsTabAction && startingPartition.getOffset() == offset && startingPartition.getType().equals("__java_singleline_comment")) {
                int max = document.getLength() - offset;
                int slashes = 2;
                while (slashes < max - 1 && document.get(offset + slashes, 2).equals("//")) {
                    slashes += 2;
                }
                wsStart = offset + slashes;
                StringBuffer computed = indenter.computeIndentation(offset);
                if (computed == null) {
                    computed = new StringBuffer(0);
                }
                int tabSize = this.getTabSize();
                while (slashes > 0 && computed.length() > 0) {
                    char c = computed.charAt(0);
                    if (c == '\t') {
                        if (slashes <= tabSize) break;
                        slashes -= tabSize;
                    } else {
                        if (c != ' ') break;
                        --slashes;
                    }
                    computed.deleteCharAt(0);
                }
                indent = String.valueOf(document.get(offset, wsStart - offset)) + computed;
            }
        }
        if (indent == null) {
            StringBuffer computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : "";
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(wsStart, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
            if (multiLine && !this.indentEmptyLines()) {
                indent = "";
            }
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        if (this.fIsTabAction && caret == end && this.whiteSpaceLength(currentIndent) >= this.whiteSpaceLength(indent)) {
            String tab = this.getTabEquivalent();
            document.replace(caret, 0, tab);
            this.fCaretOffset = caret + tab.length();
            return true;
        }
        this.fCaretOffset = caret >= offset && caret <= end ? offset + indent.length() : -1;
        if (!indent.equals(currentIndent)) {
            document.replace(offset, length, indent);
            return true;
        }
        return false;
    }

    private String computeJavadocIndent(IDocument document, int line, JavaHeuristicScanner scanner, ITypedRegion partition) throws BadLocationException {
        int lineLength;
        int lineEnd;
        if (line == 0) {
            return null;
        }
        IRegion lineInfo = document.getLineInformation(line);
        int lineStart = lineInfo.getOffset();
        int nonWS = scanner.findNonWhitespaceForwardInAnyPartition(lineStart, lineEnd = lineStart + (lineLength = lineInfo.getLength()));
        if (nonWS == -1 || document.getChar(nonWS) != '*') {
            if (nonWS == -1) {
                return document.get(lineStart, lineLength);
            }
            return document.get(lineStart, nonWS - lineStart);
        }
        IRegion previousLine = document.getLineInformation(line - 1);
        int previousLineStart = previousLine.getOffset();
        int previousLineLength = previousLine.getLength();
        int previousLineEnd = previousLineStart + previousLineLength;
        StringBuffer buf = new StringBuffer();
        int previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd);
        if (previousLineNonWS == -1 || document.getChar(previousLineNonWS) != '*') {
            previousLine = document.getLineInformationOfOffset(partition.getOffset());
            previousLineStart = previousLine.getOffset();
            previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd = previousLineStart + (previousLineLength = previousLine.getLength()));
            if (previousLineNonWS == -1) {
                previousLineNonWS = previousLineEnd;
            }
            buf.append(' ');
        }
        String indentation = document.get(previousLineStart, previousLineNonWS - previousLineStart);
        buf.insert(0, indentation);
        return buf.toString();
    }

    private int whiteSpaceLength(String indent) {
        if (indent == null) {
            return 0;
        }
        int size = 0;
        int l = indent.length();
        int tabSize = this.getTabSize();
        int i = 0;
        while (i < l) {
            size += indent.charAt(i) == '\t' ? tabSize : 1;
            ++i;
        }
        return size;
    }

    private String getTabEquivalent() {
        String tab;
        if ("space".equals(this.getCoreFormatterOption("org.eclipse.jdt.core.formatter.tabulation.char"))) {
            int size = this.getTabSize();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < size) {
                buf.append(' ');
                ++i;
            }
            tab = buf.toString();
        } else {
            tab = "\t";
        }
        return tab;
    }

    private int getTabSize() {
        return this.getCoreFormatterOption("org.eclipse.jdt.core.formatter.tabulation.size", 4);
    }

    private boolean indentEmptyLines() {
        return "true".equals(this.getCoreFormatterOption("org.eclipse.jdt.core.formatter.indent_empty_lines"));
    }

    private String getCoreFormatterOption(String key) {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return JavaCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private int getCoreFormatterOption(String key, int def) {
        try {
            return Integer.parseInt(this.getCoreFormatterOption(key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    private IJavaProject getJavaProject() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return null;
        }
        ICompilationUnit cu = JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (cu == null) {
            return null;
        }
        return cu.getJavaProject();
    }

    private ISelectionProvider getSelectionProvider() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            if (this.fIsTabAction) {
                this.setEnabled(this.canModifyEditor() && this.isSmartMode() && this.isValidSelection());
            } else {
                this.setEnabled(this.canModifyEditor() && !this.getSelection().isEmpty());
            }
        }
    }

    private boolean isValidSelection() {
        ITextSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        int offset = selection.getOffset();
        int length = selection.getLength();
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        try {
            IRegion firstLine = document.getLineInformationOfOffset(offset);
            int lineOffset = firstLine.getOffset();
            if (length == 0) {
                return document.get(lineOffset, offset - lineOffset).trim().length() == 0;
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isSmartMode() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof ITextEditorExtension3) {
            return ((ITextEditorExtension3)editor).getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider != null && input != null) {
                return provider.getDocument((Object)input);
            }
        }
        return null;
    }

    private ITextSelection getSelection() {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }
}

