/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.commands.common.NamedHandleObject;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.menus.SReference;

public final class SActionSet
extends NamedHandleObject {
    public static final String PROPERTY_DEFINED = "DEFINED";
    public static final String PROPERTY_DESCRIPTION = "DESCRIPTION";
    public static final String PROPERTY_NAME = "NAME";
    public static final String PROPERTY_REFERENCES = "REFERENCES";
    public static final String PROPERTY_VISIBLE = "VISIBLE";
    private SReference[] references;
    private boolean visible = false;

    public SActionSet(String id) {
        super(id);
    }

    public final void addListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    public final void define(String name, String description, boolean visible, SReference[] references) {
        if (name == null) {
            throw new NullPointerException("An action set needs a name");
        }
        if (references == null) {
            throw new NullPointerException("The action set must reference at least one menu element");
        }
        if (references.length == 0) {
            throw new IllegalArgumentException("The action set must reference at least one menu element");
        }
        this.setDefined(true);
        this.setName(name);
        this.setDescription(description);
        this.setVisible(visible);
        this.setReferences(references);
    }

    protected final void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    public final SReference[] getReferences() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the references from an undefined action set");
        }
        SReference[] result = new SReference[this.references.length];
        System.arraycopy(this.references, 0, result, 0, this.references.length);
        return result;
    }

    public final boolean isVisible() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the visibility from an undefined action set");
        }
        return this.visible;
    }

    public final void removeListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    protected final void setDefined(boolean defined) {
        if (this.defined != defined) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_DEFINED, (Object)(this.defined ? Boolean.TRUE : Boolean.FALSE), (Object)(defined ? Boolean.TRUE : Boolean.FALSE));
            }
            this.defined = defined;
            this.firePropertyChangeEvent(event);
        }
    }

    protected final void setDescription(String description) {
        if (!Util.equals((Object)this.description, (Object)description)) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_DESCRIPTION, (Object)this.description, (Object)description);
            }
            this.description = description;
            this.firePropertyChangeEvent(event);
        }
    }

    protected final void setName(String name) {
        if (!Util.equals((Object)this.name, (Object)name)) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_NAME, (Object)this.name, (Object)name);
            }
            this.name = name;
            this.firePropertyChangeEvent(event);
        }
    }

    protected final void setReferences(SReference[] references) {
        if (!Util.equals((Object[])this.references, (Object[])references)) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_REFERENCES, (Object)this.references, (Object)references);
            }
            this.references = references;
            this.firePropertyChangeEvent(event);
        }
    }

    protected final void setVisible(boolean visible) {
        if (this.visible != visible) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_VISIBLE, (Object)(this.visible ? Boolean.TRUE : Boolean.FALSE), (Object)(visible ? Boolean.TRUE : Boolean.FALSE));
            }
            this.visible = visible;
            this.firePropertyChangeEvent(event);
        }
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SGroup(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.visible);
            stringBuffer.append(',');
            stringBuffer.append(this.references);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        this.setReferences(this.references);
        this.setVisible(this.visible);
        this.setDescription(this.description);
        this.setName(this.name);
        this.setDefined(false);
    }
}

