/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jface.util.Assert;

public abstract class TestElement {
    private final TestSuiteElement fParent;
    private final String fId;
    private String fTestName;
    private Status fStatus;
    private String fTrace;
    private String fExpected;
    private String fActual;

    public TestElement(TestSuiteElement parent, String id, String testName) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)testName);
        this.fParent = parent;
        this.fId = id;
        this.fTestName = testName;
        this.fStatus = Status.NOT_RUN;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public TestSuiteElement getParent() {
        return this.fParent;
    }

    public String getId() {
        return this.fId;
    }

    public String getTestName() {
        return this.fTestName;
    }

    public void setName(String name) {
        this.fTestName = name;
    }

    public void setStatus(Status status) {
        this.fStatus = status;
        TestSuiteElement parent = this.getParent();
        if (parent != null) {
            parent.childChangedStatus(this, status);
        }
    }

    public void setStatus(Status status, String trace, String expected, String actual) {
        this.fTrace = trace;
        this.fExpected = expected;
        this.fActual = actual;
        this.setStatus(status);
    }

    public Status getStatus() {
        return this.fStatus;
    }

    public String getTrace() {
        return this.fTrace;
    }

    public String getExpected() {
        return this.fExpected;
    }

    public String getActual() {
        return this.fActual;
    }

    public boolean isComparisonFailure() {
        return this.fExpected != null && this.fActual != null;
    }

    public String getClassName() {
        return this.extractClassName(this.getTestName());
    }

    private String extractClassName(String testNameString) {
        int index = testNameString.indexOf(40);
        if (index < 0) {
            return testNameString;
        }
        testNameString = testNameString.substring(index + 1);
        return testNameString.substring(0, testNameString.indexOf(41));
    }

    public TestRoot getRoot() {
        return this.getParent().getRoot();
    }

    public String toString() {
        return String.valueOf(this.getTestName()) + ": " + this.getStatus();
    }

    public static final class Status {
        public static final Status RUNNING_ERROR = new Status("RUNNING_ERROR", 5);
        public static final Status RUNNING_FAILURE = new Status("RUNNING_FAILURE", 6);
        public static final Status RUNNING = new Status("RUNNING", 3);
        public static final Status ERROR = new Status("ERROR", 1);
        public static final Status FAILURE = new Status("FAILURE", 2);
        public static final Status OK = new Status("OK", 0);
        public static final Status NOT_RUN = new Status("NOT_RUN", 4);
        private static final Status[] OLD_CODE = new Status[]{OK, ERROR, FAILURE};
        private final String fName;
        private final int fOldCode;

        private Status(String name, int oldCode) {
            this.fName = name;
            this.fOldCode = oldCode;
        }

        public int getOldCode() {
            return this.fOldCode;
        }

        public String toString() {
            return this.fName;
        }

        public boolean isOK() {
            return this == OK || this == RUNNING || this == NOT_RUN;
        }

        public boolean isFailure() {
            return this == FAILURE || this == RUNNING_FAILURE;
        }

        public boolean isError() {
            return this == ERROR || this == RUNNING_ERROR;
        }

        public boolean isErrorOrFailure() {
            return this.isError() || this.isFailure();
        }

        public boolean isNotRun() {
            return this == NOT_RUN;
        }

        public boolean isRunning() {
            return this == RUNNING || this == RUNNING_FAILURE || this == RUNNING_ERROR;
        }

        public boolean isDone() {
            return this == OK || this == FAILURE || this == ERROR;
        }

        public static Status combineStatus(Status one, Status two) {
            Status progress = Status.combineProgress(one, two);
            Status error = Status.combineError(one, two);
            return Status.combineProgressAndErrorStatus(progress, error);
        }

        private static Status combineProgress(Status one, Status two) {
            if (one.isNotRun() && two.isNotRun()) {
                return NOT_RUN;
            }
            if (one.isDone() && two.isDone()) {
                return OK;
            }
            if (!one.isRunning() && !two.isRunning()) {
                return OK;
            }
            return RUNNING;
        }

        private static Status combineError(Status one, Status two) {
            if (one.isError() || two.isError()) {
                return ERROR;
            }
            if (one.isFailure() || two.isFailure()) {
                return FAILURE;
            }
            return OK;
        }

        private static Status combineProgressAndErrorStatus(Status progress, Status error) {
            if (progress.isDone()) {
                if (error.isError()) {
                    return ERROR;
                }
                if (error.isFailure()) {
                    return FAILURE;
                }
                return OK;
            }
            if (progress.isNotRun()) {
                return NOT_RUN;
            }
            if (error.isError()) {
                return RUNNING_ERROR;
            }
            if (error.isFailure()) {
                return RUNNING_FAILURE;
            }
            return RUNNING;
        }

        public static Status convert(int oldStatus) {
            return OLD_CODE[oldStatus];
        }
    }
}

