/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.appserver.AppserverPlugin;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;

public class AppserverPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Text textServerAddr;
    protected Text textServerPort;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageAppServer");
        final Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(1808));
        final GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        final Label descLabel = new Label(mainComposite, 64);
        descLabel.setText(Messages.AppserverPreferencePage_description);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 100;
        data.heightHint = 20;
        descLabel.setLayoutData((Object)data);
        descLabel.setFont(font);
        Label label = new Label(mainComposite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        label = new Label(mainComposite, 0);
        label.setFont(font);
        label.setText(Messages.AppserverPreferencePage_hostDescription);
        this.textServerAddr = new Text(mainComposite, 2052);
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(8);
        this.textServerAddr.setLayoutData((Object)data);
        this.textServerAddr.setFont(font);
        label = new Label(mainComposite, 0);
        label.setFont(font);
        label.setText(Messages.AppserverPreferencePage_portDescription);
        this.textServerPort = new Text(mainComposite, 2052);
        this.textServerPort.setTextLimit(5);
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(8);
        this.textServerPort.setLayoutData((Object)data);
        this.textServerPort.setFont(font);
        this.textServerPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AppserverPreferencePage.this.textServerPort.getText().length() == 0) {
                    AppserverPreferencePage.this.setValid(true);
                    AppserverPreferencePage.this.setErrorMessage(null);
                    return;
                }
                try {
                    int num = Integer.valueOf(AppserverPreferencePage.this.textServerPort.getText());
                    if (num >= 0 && num <= 65535) {
                        AppserverPreferencePage.this.setValid(true);
                        AppserverPreferencePage.this.setErrorMessage(null);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                AppserverPreferencePage.this.setValid(false);
                AppserverPreferencePage.this.setErrorMessage(Messages.AppserverPreferencePage_invalidPort);
            }
        });
        label = new Label(mainComposite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        FormText ftext = new FormText(mainComposite, 64);
        ftext.setText(Messages.AppserverPreferencePage_requireRestart, true, false);
        data = new GridData(512);
        ftext.setHyperlinkSettings(new HyperlinkSettings(mainComposite.getDisplay()));
        data.horizontalSpan = 2;
        data.widthHint = 100;
        data.heightHint = 20;
        ftext.setLayoutData((Object)data);
        ftext.setFont(font);
        final GridData fdata = data;
        mainComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int width;
                GridData ddata = (GridData)descLabel.getLayoutData();
                fdata.widthHint = width = mainComposite.getSize().x - layout.marginWidth * 2;
                fdata.heightHint = -1;
                ddata.widthHint = width;
                ddata.heightHint = -1;
                mainComposite.layout();
            }
        });
        Preferences pref = AppserverPlugin.getDefault().getPluginPreferences();
        this.textServerAddr.setText(pref.getString("host"));
        this.textServerPort.setText(pref.getString("port"));
        return mainComposite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        Preferences pref = AppserverPlugin.getDefault().getPluginPreferences();
        this.textServerAddr.setText(pref.getDefaultString("host"));
        this.textServerPort.setText(pref.getDefaultString("port"));
        super.performDefaults();
    }

    public boolean performOk() {
        Preferences pref = AppserverPlugin.getDefault().getPluginPreferences();
        pref.setValue("host", this.textServerAddr.getText());
        pref.setValue("port", this.textServerPort.getText());
        AppserverPlugin.getDefault().savePluginPreferences();
        return true;
    }
}

