/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.core.containment.GroupID;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.server.extensions.internal.drop.DropObject;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;

public class DropAction extends Action
{
	
	public void run(IAction action) 
	{		
		Iterator iterSel = selection.iterator(); 
		int queryDelete = 0;
		ArrayList refreshSchemaList = new ArrayList();
	
		while (iterSel.hasNext()) {
			Object obj = iterSel.next();			   
			SQLObject sqlObj =(SQLObject)obj;
			
			if (sqlObj != null) {
				if (queryDelete != 1) // 1 = YES_TO_ALL 
				{  
					queryDelete = Utility.isOkayToDrop(sqlObj.getName());
					switch (queryDelete) 
					{
					   case 2 :        // NO pressed
					      continue; 
					   case 3 :        // CANCEL pressed
					   case -1 :
					      return;
					   default :       // YES, YES_TO_ALL
					      break;   
					}
				}
				
				DropObject dropObj = new DropObject(sqlObj);
				ConnectionInfo conInfo = null;
				if (obj instanceof ICatalogObject) {
				   ICatalogObject catalogObject = (ICatalogObject)obj;
				   
				   Database database = catalogObject.getCatalogDatabase();
				   conInfo = Utility.getConnectionInfo(database);
				   
				   Object parent = IServicesManager.INSTANCE.getServerExplorerNavigationService().getParent(obj);				   
				   if (parent != null && parent instanceof IVirtualNode) {
				      Object schema = ((IVirtualNode)parent).getParent();
				      if (schema != null && !refreshSchemaList.contains(schema)) {
				         refreshSchemaList.add(schema);
				      }
				   }
				}
				
				dropObj.run(conInfo);
			}
		} 

		// refresh schema folders
		Iterator itRefreshSchemas = refreshSchemaList.iterator();
		while (itRefreshSchemas.hasNext()) {
		   IServicesManager.INSTANCE.getServerExplorerRefreshService().refresh(itRefreshSchemas.next());
		}
				
	}
    
	public void selectionChanged(IAction action, ISelection selection) {
        
        super.selectionChanged(action, selection);
        
        if (!action.isEnabled())
            return;
        
        boolean ok = true; 
        
        if (selection instanceof IStructuredSelection) {
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {                
            	Object o = it.next();
                if (o instanceof EObject) {
                    String groupID = containmentService.getGroupId((EObject)o);
                    if (groupID==null || !groupID.startsWith(GroupID.CORE_PREFIX)) {
                        ok = false;
                        break;
                    }
                } else {
                    ok = false;
                    break;
                }
            }                       
        } else {
            ok = false;
        }
        
        action.setEnabled(ok);        
	}
}

