/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.rdb.connection.internal.ui.RDBConnectionUIPlugin;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionSelectionExistingWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionSelectionFilterWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionSelectionJDBCWizardPage;
import org.eclipse.wst.rdb.core.internal.ui.RDBCoreUIPlugin;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogProvider;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class ConnectionSelectionWizard
extends Wizard {
    public static final String SKIP = "skip";
    public static final String CONNECTION_SELECTION_EXISTINGPAGE_NAME = "ConnectionSelectionExistingWizardPage";
    public static final String CONNECTION_SELECTION_JDBCPAGE_NAME = "ConnectionSelectionJDBCWizardPage";
    public static final String CONNECTION_SELECTION_FILTER_NAME = "ConnectionSelectionFilterWizardPage";
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    protected ConnectionSelectionExistingWizardPage existingPage;
    protected ConnectionSelectionJDBCWizardPage jdbcPage;
    protected ConnectionSelectionFilterWizardPage filterPage;
    protected List myStartingConInfoNames;
    protected boolean actionCanceled;
    private ConnectionInfo connectionInfo;

    public ConnectionSelectionWizard() {
        this.setWindowTitle(resourceLoader.queryString("CUI_CONN_SELECT_EXT_PAGE_TITLE"));
        URL coreUIPluginURL = RDBCoreUIPlugin.getInstallURL();
        String imagePath = "icons" + File.separator + "connection_wiz.gif";
        try {
            ImageDescriptor connWizardImageDescriptor = ImageDescriptor.createFromURL((URL)new URL(coreUIPluginURL, imagePath));
            this.setDefaultPageImageDescriptor(connWizardImageDescriptor);
        }
        catch (MalformedURLException malformedURLException) {}
        IDialogSettings workbenchSettings = RDBConnectionUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("connection.ui.connectionselection");
        if (section == null) {
            section = workbenchSettings.addNewSection("connection.ui.connectionselection");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.existingPage = new ConnectionSelectionExistingWizardPage(CONNECTION_SELECTION_EXISTINGPAGE_NAME);
        this.addPage((IWizardPage)this.existingPage);
        this.jdbcPage = new ConnectionSelectionJDBCWizardPage(CONNECTION_SELECTION_JDBCPAGE_NAME);
        this.addPage((IWizardPage)this.jdbcPage);
        this.filterPage = new ConnectionSelectionFilterWizardPage(CONNECTION_SELECTION_FILTER_NAME);
        this.addPage((IWizardPage)this.filterPage);
        this.myStartingConInfoNames = this.getStartingConInfoNames();
    }

    public List getStartingConInfoNames() {
        ConnectionInfo[] conInfos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < conInfos.length) {
            list.add(conInfos[i].getName());
            ++i;
        }
        return list;
    }

    public void removeConnection() {
        if (this.connectionInfo != null) {
            this.removeConnection(this.connectionInfo.getName());
        }
    }

    public void removeConnection(String aConName) {
        if (aConName != null & !this.myStartingConInfoNames.contains(aConName)) {
            RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(aConName);
        }
    }

    public void setConInfo(ConnectionInfo info) {
        this.connectionInfo = info;
    }

    public boolean createConnection() {
        if (this.connectionInfo != null) {
            this.removeConnection(this.connectionInfo.getName());
            this.connectionInfo = null;
        }
        this.jdbcPage.internalSaveWidgetValues();
        this.jdbcPage.performTestConnection(false);
        boolean rtnCode = this.jdbcPage.isFinalConnection();
        if (rtnCode) {
            this.connectionInfo = this.jdbcPage.getConnection();
            try {
                this.addConnection(this.connectionInfo);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return rtnCode;
    }

    public void reconnect(ConnectionInfo info) throws Exception {
        this.addConnection(info);
    }

    public ConnectionInfo addConnection(ConnectionInfo info) throws Exception {
        Connection connection = null;
        try {
            connection = info.connect();
            info.setSharedConnection(connection);
            info.saveConnectionInfo();
            this.setDatabase(connection, info, info.getDatabaseName());
        }
        catch (Exception e) {
            this.removeConnection(info.getName());
            connection = null;
            throw e;
        }
        return info;
    }

    public void setDatabase(Connection connection, ConnectionInfo info, String databaseName) {
        Database database = this.getCatalogDatabase(connection, info);
        database.setName(databaseName);
    }

    private Database getCatalogDatabase(Connection connection, ConnectionInfo info) {
        ICatalogProvider catalogProvider = info.getDatabaseDefinition().getDatabaseCatalogProvider();
        Database database = catalogProvider.getCatalogDatabase(connection);
        RDBCorePlugin.getDefault().getConnectionManager().setConnectionInfo((SQLObject)database, info);
        this.setSharedInformation(info, database);
        return database;
    }

    private void setSharedInformation(ConnectionInfo info, Database database) {
        if (info.getSharedDatabase() != null) {
            info.removeSharedDatabase();
        }
        info.setSharedDatabase(database);
    }

    public ConnectionInfo getConInfo() {
        return this.connectionInfo;
    }

    public boolean isActionCanceled() {
        return this.actionCanceled;
    }

    public boolean canFinish() {
        if (this.existingPage.isExistingConnectionSelected()) {
            this.existingPage.refresh();
            return this.existingPage.isConnected();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        this.actionCanceled = false;
        if (this.connectionInfo != null && this.filterPage != null && this.filterPage.getControl().getData(SKIP) == Boolean.FALSE) {
            this.filterPage.applyFilter();
            Database db = this.connectionInfo.getSharedDatabase();
            ((ICatalogObject)db).refresh();
        } else if (this.existingPage.isNewConnectionSelected() && this.filterPage.getControl().getData(SKIP) == Boolean.TRUE) {
            this.createConnection();
        }
        return this.connectionInfo != null;
    }

    public boolean performCancel() {
        this.actionCanceled = true;
        if (this.connectionInfo != null) {
            this.removeConnection();
            this.connectionInfo = null;
        }
        return super.performCancel();
    }
}

