/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.fe.internal.ui.wizards;

import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.ExistingConnectionsWizardPage;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

public class FESpecifyExistingConnectionsWizardPage
extends ExistingConnectionsWizardPage {
    private String allowedProduct = null;
    private String allowedVersion = null;

    public FESpecifyExistingConnectionsWizardPage(String pageName) {
        super(pageName);
    }

    protected ConnectionInfo[] getConnectionsToDisplay() {
        Vector<ConnectionInfo> filteredInfosCollection = new Vector<ConnectionInfo>();
        Object[] filteredInfos = new ConnectionInfo[]{};
        ConnectionInfo[] allInfos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
        if (this.getAllowedProduct() != null && this.getAllowedVersion() != null) {
            int infoLength = allInfos.length;
            if (infoLength > 0) {
                int index = 0;
                while (index < infoLength) {
                    if (allInfos[index].getDatabaseDefinition().getProduct().equals(this.getAllowedProduct())) {
                        filteredInfosCollection.add(allInfos[index]);
                    }
                    filteredInfos = new ConnectionInfo[filteredInfosCollection.size()];
                    filteredInfosCollection.copyInto(filteredInfos);
                    ++index;
                }
            }
        } else {
            filteredInfos = allInfos;
        }
        return filteredInfos;
    }

    public void setAllowedProduct(String allowedProduct) {
        this.allowedProduct = allowedProduct;
    }

    public String getAllowedProduct() {
        return this.allowedProduct;
    }

    public void setAllowedVersion(String allowedVersion) {
        this.allowedVersion = allowedVersion;
    }

    public String getAllowedVersion() {
        return this.allowedVersion;
    }

    public boolean isSelectedConnectionClosed() {
        boolean isClosed = true;
        ConnectionInfo connectionInfo = this.getSelectedConnection();
        if (connectionInfo != null && connectionInfo.getSharedConnection() != null) {
            try {
                if (!connectionInfo.getSharedConnection().isClosed()) {
                    isClosed = false;
                }
            }
            catch (SQLException sQLException) {}
        }
        return isClosed;
    }
}

