/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;

public class SelectionCollector
extends AbstractCssTraverser {
    int start;
    int end;
    List selectedNodes;

    protected void begin(ICSSNode node) {
        this.selectedNodes = new ArrayList();
    }

    public List getSelectedNodes() {
        if (this.selectedNodes == null) {
            return new ArrayList();
        }
        return new ArrayList(this.selectedNodes);
    }

    protected short preNode(ICSSNode node) {
        IndexedRegion iNode = (IndexedRegion)node;
        if (iNode.getStartOffset() <= this.end && this.start < iNode.getEndOffset()) {
            if (node.getNodeType() != 7) {
                IndexedRegion iFirstChild = (IndexedRegion)node.getFirstChild();
                IndexedRegion iLastChild = (IndexedRegion)node.getLastChild();
                if (iFirstChild == null || this.start < iFirstChild.getStartOffset() || iLastChild.getEndOffset() <= this.end) {
                    this.selectedNodes.add(node);
                }
            }
            return TRAV_CONT;
        }
        if (iNode.getStartOffset() > this.end) {
            return TRAV_STOP;
        }
        return TRAV_PRUNE;
    }

    public void setRegion(int newStart, int newEnd) {
        this.start = newStart;
        this.end = newEnd;
    }
}

