/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.ElementOperations;

public class ElementImportOperations
extends ElementOperations {
    protected ElementImportOperations() {
    }

    public static boolean validateVisibilityPublicOrPrivate(ElementImport elementImport, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        VisibilityKind visibility = elementImport.getVisibility();
        if (visibility != VisibilityKind.PUBLIC_LITERAL && visibility != VisibilityKind.PRIVATE_LITERAL) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 8, UMLPlugin.INSTANCE.getString("_UI_ElementImport_VisibilityPublicOrPrivate_diagnostic", ElementImportOperations.getMessageSubstitutions((Map)context, (Object)elementImport)), new Object[]{elementImport}));
            }
        }
        return result;
    }

    public static boolean validateImportedElementIsPublic(ElementImport elementImport, DiagnosticChain diagnostics, Map context) {
        VisibilityKind visibility;
        boolean result = true;
        PackageableElement importedElement = elementImport.getImportedElement();
        VisibilityKind visibilityKind = visibility = importedElement == null ? null : importedElement.getVisibility();
        if (visibility != null && visibility != VisibilityKind.PUBLIC_LITERAL) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 9, UMLPlugin.INSTANCE.getString("_UI_ElementImport_ImportedElementIsPublic_diagnostic", ElementImportOperations.getMessageSubstitutions((Map)context, (Object)importedElement)), new Object[]{elementImport, importedElement}));
            }
        }
        return result;
    }

    public static String getName(ElementImport elementImport) {
        String alias = elementImport.getAlias();
        if (ElementImportOperations.isEmpty((String)alias)) {
            PackageableElement importedElement = elementImport.getImportedElement();
            return importedElement == null ? null : importedElement.getName();
        }
        return alias;
    }
}

