/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.core.RubyElement;

class RubyElementInfo {
    protected IRubyElement[] children = RubyElement.NO_ELEMENTS;
    protected boolean isStructureKnown = false;
    static Object[] NO_NON_RUBY_RESOURCES = new Object[0];

    protected RubyElementInfo() {
    }

    public void addChild(IRubyElement iRubyElement) {
        if (this.children == RubyElement.NO_ELEMENTS) {
            this.setChildren(new IRubyElement[]{iRubyElement});
        } else if (!this.includesChild(iRubyElement)) {
            this.setChildren(this.growAndAddToArray(this.children, iRubyElement));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public IRubyElement[] getChildren() {
        return this.children;
    }

    protected IRubyElement[] growAndAddToArray(IRubyElement[] iRubyElementArray, IRubyElement iRubyElement) {
        IRubyElement[] iRubyElementArray2 = iRubyElementArray;
        iRubyElementArray = new IRubyElement[iRubyElementArray2.length + 1];
        System.arraycopy(iRubyElementArray2, 0, iRubyElementArray, 0, iRubyElementArray2.length);
        iRubyElementArray[iRubyElementArray2.length] = iRubyElement;
        return iRubyElementArray;
    }

    protected boolean includesChild(IRubyElement iRubyElement) {
        int n = 0;
        while (n < this.children.length) {
            if (this.children[n].equals(iRubyElement)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isStructureKnown() {
        return this.isStructureKnown;
    }

    protected IRubyElement[] removeAndShrinkArray(IRubyElement[] iRubyElementArray, IRubyElement iRubyElement) {
        IRubyElement[] iRubyElementArray2 = iRubyElementArray;
        iRubyElementArray = new IRubyElement[iRubyElementArray2.length - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < iRubyElementArray2.length) {
            if (iRubyElementArray2[n2].equals(iRubyElement)) {
                System.arraycopy(iRubyElementArray2, n2 + 1, iRubyElementArray, n, iRubyElementArray2.length - (n2 + 1));
                return iRubyElementArray;
            }
            iRubyElementArray[n] = iRubyElementArray2[n2];
            ++n;
            ++n2;
        }
        return iRubyElementArray;
    }

    public void removeChild(IRubyElement iRubyElement) {
        if (this.includesChild(iRubyElement)) {
            this.setChildren(this.removeAndShrinkArray(this.children, iRubyElement));
        }
    }

    public void setChildren(IRubyElement[] iRubyElementArray) {
        this.children = iRubyElementArray;
    }

    public void setIsStructureKnown(boolean bl) {
        this.isStructureKnown = bl;
    }
}

