/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.RubyDebuggerProxy;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.launching.InterpreterRunner;
import org.rubypeople.rdt.internal.launching.InterpreterRunnerConfiguration;
import org.rubypeople.rdt.internal.launching.RdtLaunchingMessages;
import org.rubypeople.rdt.internal.launching.RdtLaunchingPlugin;

public class DebuggerRunner
extends InterpreterRunner {
    private RubyDebugTarget debugTarget;

    public IProcess run(InterpreterRunnerConfiguration interpreterRunnerConfiguration, ILaunch iLaunch) throws CoreException {
        this.debugTarget = new RubyDebugTarget(iLaunch);
        IProcess iProcess = super.run(interpreterRunnerConfiguration, iLaunch);
        this.debugTarget.setProcess(iProcess);
        RubyDebuggerProxy rubyDebuggerProxy = new RubyDebuggerProxy((IRubyDebugTarget)this.debugTarget);
        if (rubyDebuggerProxy.checkConnection()) {
            rubyDebuggerProxy.start();
            iLaunch.addDebugTarget((IDebugTarget)this.debugTarget);
        } else {
            RdtLaunchingPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.launching", 4, RdtLaunchingMessages.getString("RdtLaunchingPlugin.processTerminatedBecauseNoDebuggerConnection"), null));
            this.debugTarget.terminate();
        }
        return iProcess;
    }

    protected void addDebugCommandLineArgument(List list) {
        if (!this.debugTarget.isUsingDefaultPort()) {
            list.add("-r" + this.debugTarget.getDebugParameterFile().getAbsolutePath());
        }
        if (RdtDebugCorePlugin.isRubyDebuggerVerbose()) {
            list.add("-reclipseDebugVerbose");
        } else {
            list.add("-reclipseDebug");
        }
        list.add("-I");
        list.add(RdtLaunchingPlugin.osDependentPath(DebuggerRunner.getDirectoryOfRubyDebuggerFile().replace('/', File.separatorChar)));
    }

    public static String getDirectoryOfRubyDebuggerFile() {
        return String.valueOf(RubyCore.getOSDirectory((Plugin)RdtLaunchingPlugin.getDefault())) + "ruby";
    }
}

