/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.filter.SignatureUtil;

public class MethodMatcher
implements Matcher {
    private NameMatch name;
    private String signature;

    public MethodMatcher(String name) {
        this.name = new NameMatch(name);
    }

    public MethodMatcher(String name, String params, String returns) {
        this.name = new NameMatch(name);
        this.signature = SignatureUtil.createMethodSignature(params, returns);
    }

    public boolean match(BugInstance bugInstance) {
        MethodAnnotation methodAnnotation = bugInstance.getPrimaryMethod();
        if (methodAnnotation == null) {
            return false;
        }
        if (!this.name.match(methodAnnotation.getMethodName())) {
            return false;
        }
        return this.signature == null || this.signature.equals(methodAnnotation.getMethodSignature());
    }
}

