/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.constant;

import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.SIPUSH;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantFrameModelingVisitor
extends AbstractFrameModelingVisitor<Constant, ConstantFrame> {
    public ConstantFrameModelingVisitor(ConstantPoolGen cpg) {
        super(cpg);
    }

    @Override
    public Constant getDefaultValue() {
        return Constant.NOT_CONSTANT;
    }

    @Override
    public void visitIINC(IINC obj) {
        int v = obj.getIndex();
        int amount = obj.getIncrement();
        ConstantFrame f = (ConstantFrame)this.getFrame();
        Constant c = (Constant)f.getValue(v);
        if (c.isConstantInteger()) {
            f.setValue(v, new Constant(new Integer(c.getConstantInt() + amount)));
        } else {
            f.setValue(v, Constant.NOT_CONSTANT);
        }
    }

    @Override
    public void visitICONST(ICONST obj) {
        Number value = obj.getValue();
        Constant c = new Constant(value);
        ((ConstantFrame)this.getFrame()).pushValue(c);
    }

    @Override
    public void visitBIPUSH(BIPUSH obj) {
        Number value = obj.getValue();
        Constant c = new Constant(value);
        ((ConstantFrame)this.getFrame()).pushValue(c);
    }

    @Override
    public void visitSIPUSH(SIPUSH obj) {
        Number value = obj.getValue();
        Constant c = new Constant(value);
        ((ConstantFrame)this.getFrame()).pushValue(c);
    }

    @Override
    public void visitLDC(LDC obj) {
        Object value = obj.getValue(this.getCPG());
        Constant c = new Constant(value);
        ((ConstantFrame)this.getFrame()).pushValue(c);
    }

    @Override
    public void visitLDC2_W(LDC2_W obj) {
        Number value = obj.getValue(this.getCPG());
        Constant c = new Constant(value);
        ((ConstantFrame)this.getFrame()).pushValue(c);
        ((ConstantFrame)this.getFrame()).pushValue(c);
    }

    @Override
    public /* synthetic */ Object getDefaultValue() {
        return this.getDefaultValue();
    }
}

