/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.ClassMember;

public abstract class AbstractClassMember
implements ClassMember {
    private final String className;
    private final String name;
    private final String signature;
    private final int accessFlags;
    private boolean resolved;
    private int cachedHashCode = 0;
    static int slashCountClass;
    static int dottedCountClass;
    static int slashCountSignature;
    static int dottedCountSignature;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractClassMember(String className, String name, String signature, int accessFlags) {
        if (className.indexOf(46) >= 0) {
            ++dottedCountClass;
        } else if (className.indexOf(47) >= 0) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            ++slashCountClass;
            className = className.replace('/', '.');
        }
        if (signature.indexOf(46) >= 0) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            signature = signature.replace('.', '/');
            ++dottedCountSignature;
        } else if (signature.indexOf(47) >= 0) {
            ++slashCountSignature;
        }
        this.className = className;
        this.name = name;
        this.signature = signature;
        this.accessFlags = accessFlags;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        int lastDot = this.className.lastIndexOf(46);
        if (lastDot == -1) {
            return this.className;
        }
        return this.className.substring(0, lastDot);
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isReferenceType() {
        return this.signature.startsWith("L") || this.signature.startsWith("[");
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public int compareTo(ClassMember other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int cmp = this.className.compareTo(other.getClassName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.name.compareTo(other.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.signature.compareTo(other.getSignature());
    }

    public boolean isResolved() {
        return this.resolved;
    }

    void markAsResolved() {
        this.resolved = true;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.className.hashCode() ^ this.name.hashCode() ^ this.signature.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractClassMember other = (AbstractClassMember)o;
        return this.className.equals(other.className) && this.name.equals(other.name) && this.signature.equals(other.signature);
    }

    public String toString() {
        return this.className + "." + this.name;
    }

    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((ClassMember)x0);
    }

    static {
        $assertionsDisabled = !AbstractClassMember.class.desiredAssertionStatus();
        slashCountClass = 0;
        dottedCountClass = 0;
        slashCountSignature = 0;
        dottedCountSignature = 0;
    }
}

