/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.I18N;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugPattern
implements Comparable<BugPattern> {
    private String type;
    private String abbrev;
    private String category;
    private boolean experimental;
    private String shortDescription;
    private String longDescription;
    private String detailText;
    private String detailHTML;

    public BugPattern(String type, String abbrev, String category, boolean experimental, String shortDescription, String longDescription, String detailText) {
        this.type = type;
        this.abbrev = abbrev;
        this.category = category;
        this.experimental = experimental;
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.detailText = detailText;
    }

    public String getType() {
        return this.type;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryAbbrev() {
        String categoryAbbrev = null;
        BugCategory bcat = I18N.instance().getBugCategory(this.getCategory());
        if (bcat != null) {
            categoryAbbrev = bcat.getAbbrev();
        }
        if (categoryAbbrev == null) {
            categoryAbbrev = "X";
        }
        return categoryAbbrev;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getDetailText() {
        return this.detailText;
    }

    public String getDetailHTML() {
        if (this.detailHTML == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
            buf.append("<HTML><HEAD><TITLE>");
            buf.append(this.getShortDescription());
            buf.append("</TITLE></HEAD><BODY><H1>");
            buf.append(this.getShortDescription());
            buf.append("</H1>\n");
            buf.append(this.getDetailText());
            buf.append("</BODY></HTML>\n");
            this.detailHTML = buf.toString();
        }
        return this.detailHTML;
    }

    @Override
    public int compareTo(BugPattern other) {
        return this.type.compareTo(other.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BugPattern)) {
            return false;
        }
        BugPattern other = (BugPattern)o;
        return this.type.equals(other.type);
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((BugPattern)x0);
    }
}

