/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.model.ClassFeatureSet;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BugCollection {
    public static final String ROOT_ELEMENT_NAME = "BugCollection";
    public static final String SRCMAP_ELEMENT_NAME = "SrcMap";
    public static final String PROJECT_ELEMENT_NAME = "Project";
    public static final String ERRORS_ELEMENT_NAME = "Errors";
    public static final String ANALYSIS_ERROR_ELEMENT_NAME = "AnalysisError";
    public static final String ERROR_ELEMENT_NAME = "Error";
    public static final String ERROR_MESSAGE_ELEMENT_NAME = "ErrorMessage";
    public static final String ERROR_EXCEPTION_ELEMENT_NAME = "Exception";
    public static final String ERROR_STACK_TRACE_ELEMENT_NAME = "StackTrace";
    public static final String MISSING_CLASS_ELEMENT_NAME = "MissingClass";
    public static final String SUMMARY_HTML_ELEMENT_NAME = "SummaryHTML";
    public static final String APP_CLASS_ELEMENT_NAME = "AppClass";
    public static final String CLASS_HASHES_ELEMENT_NAME = "ClassHashes";
    public static final String HISTORY_ELEMENT_NAME = "History";

    public void setReleaseName(String var1);

    public String getReleaseName();

    public ProjectStats getProjectStats();

    public void setTimestamp(long var1);

    public long getTimestamp();

    public void setAnalysisTimestamp(long var1);

    public long getAnalysisTimestamp();

    public AppVersion getAppVersionFromSequenceNumber(long var1);

    public void setSequenceNumber(long var1);

    public long getSequenceNumber();

    public void clearAppVersions();

    public void addAppVersion(AppVersion var1);

    public AppVersion getCurrentAppVersion();

    public Iterator<AppVersion> appVersionIterator();

    public boolean add(BugInstance var1);

    public boolean add(BugInstance var1, boolean var2);

    @Deprecated
    public BugInstance lookupFromUniqueId(String var1);

    public void addError(String var1);

    public void addError(AnalysisError var1);

    public void addMissingClass(String var1);

    public void setClassFeatureSet(ClassFeatureSet var1);

    public void writePrologue(XMLOutput var1, Project var2) throws IOException;

    public void writeEpilogue(XMLOutput var1) throws IOException;

    public void clearClassFeatures();

    public void readXML(String var1, Project var2) throws IOException, DocumentException;

    public void readXML(InputStream var1, Project var2) throws IOException, DocumentException;

    public void writeXML(String var1, Project var2) throws IOException;

    public void writeXML(OutputStream var1, Project var2) throws IOException;

    public void writeXML(XMLOutput var1, Project var2) throws IOException;

    public Iterator<BugInstance> iterator();

    public Collection<BugInstance> getCollection();

    public Document toDocument(Project var1);

    public BugCollection createEmptyCollectionWithMetadata();

    public void setWithMessages(boolean var1);

    public boolean getWithMessages();

    public BugInstance findBug(String var1, String var2, int var3);
}

