/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompInactivityMonitor;
import org.apache.activemq.transport.stomp.StompTransport;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StompSocket
extends TransportSupport
implements WebSocket.OnTextMessage,
StompTransport {
    private static final Logger LOG = LoggerFactory.getLogger(StompSocket.class);
    WebSocket.Connection outbound;
    ProtocolConverter protocolConverter = new ProtocolConverter((StompTransport)this, null);
    StompWireFormat wireFormat = new StompWireFormat();
    private final CountDownLatch socketTransportStarted = new CountDownLatch(1);

    StompSocket() {
    }

    public void onOpen(WebSocket.Connection connection) {
        this.outbound = connection;
    }

    public void onClose(int closeCode, String message) {
        try {
            this.protocolConverter.onStompCommand(new StompFrame("DISCONNECT"));
        }
        catch (Exception e) {
            LOG.warn("Failed to close WebSocket", (Throwable)e);
        }
    }

    public void onMessage(String data) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for StompSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for StompSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        try {
            this.protocolConverter.onStompCommand((StompFrame)this.wireFormat.unmarshal(new ByteSequence(data.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
    }

    private boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }

    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    public int getReceiveCounter() {
        return 0;
    }

    public String getRemoteAddress() {
        return "StompSocket_" + ((Object)((Object)this)).hashCode();
    }

    public void oneway(Object command) throws IOException {
        try {
            this.protocolConverter.onActiveMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
    }

    public void sendToActiveMQ(Command command) {
        this.doConsume(command);
    }

    public void sendToStomp(StompFrame command) throws IOException {
        this.outbound.sendMessage(command.format());
    }

    public StompInactivityMonitor getInactivityMonitor() {
        return null;
    }

    public StompWireFormat getWireFormat() {
        return this.wireFormat;
    }
}

