/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import io.hawt.util.Strings;
import java.io.File;
import java.io.FileFilter;

public class FileFilters {
    private static final FileFilter TRUE_FILTER = new FileFilter(){

        public String toString() {
            return "TrueFileFilter";
        }

        public boolean accept(File pathname) {
            return true;
        }
    };

    public static FileFilter createFileFilter(String wildcard) {
        if (Strings.isNotBlank(wildcard)) {
            int idx = wildcard.indexOf(42);
            if (idx < 0) {
                return FileFilters.nameEqualsFilter(wildcard);
            }
            int lastIdx = wildcard.lastIndexOf(idx);
            if (lastIdx < 0) {
                lastIdx = idx;
            }
            FileFilter endsWith = FileFilters.nameEndsWithFilter(wildcard.substring(lastIdx + 1));
            if (idx <= 0) {
                return endsWith;
            }
            return FileFilters.andFilter(FileFilters.nameStartsWithFilter(wildcard.substring(0, idx)), endsWith);
        }
        return FileFilters.trueFilter();
    }

    public static FileFilter nameEqualsFilter(final String name) {
        return new FileFilter(){

            public String toString() {
                return "FileNameEqualsFilter(" + name + ")";
            }

            public boolean accept(File file) {
                return name.equals(file.getName());
            }
        };
    }

    public static FileFilter nameStartsWithFilter(final String name) {
        return new FileFilter(){

            public String toString() {
                return "FileNameStartsWithFilter(" + name + ")";
            }

            public boolean accept(File file) {
                return file.getName().startsWith(name);
            }
        };
    }

    public static FileFilter nameEndsWithFilter(final String name) {
        return new FileFilter(){

            public String toString() {
                return "FileNameEndsWithFilter(" + name + ")";
            }

            public boolean accept(File file) {
                return file.getName().endsWith(name);
            }
        };
    }

    public static FileFilter andFilter(final FileFilter filter1, final FileFilter filter2) {
        return new FileFilter(){

            public String toString() {
                return "AndFilter(" + filter1 + " && " + filter2 + ")";
            }

            public boolean accept(File file) {
                return filter1.accept(file) && filter2.accept(file);
            }
        };
    }

    public static FileFilter trueFilter() {
        return TRUE_FILTER;
    }
}

