/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.git;

import io.hawt.config.ConfigFacade;
import io.hawt.git.CommitInfo;
import io.hawt.git.FileContents;
import io.hawt.git.FileInfo;
import io.hawt.git.GitFacadeSupport;
import io.hawt.git.RuntimeIOException;
import io.hawt.util.Objects;
import io.hawt.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitFacade
extends GitFacadeSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitFacade.class);
    private String configDirName;
    private File configDirectory;
    private String remoteRepository;
    private Git git;
    private Object lock = new Object();
    private String remote = "origin";
    private String defaultRemoteRepository = "https://github.com/hawtio/hawtio-config.git";
    private boolean cloneRemoteRepoOnStartup = true;
    private boolean pullOnStartup = true;
    private CredentialsProvider credentials;
    private boolean cloneAllBranches = false;
    private boolean pushOnCommit = false;
    private boolean pullBeforeOperation = false;
    private long pullTimePeriod;
    private Timer timer;
    private TimerTask task;
    private PersonIdent stashPersonIdent;
    private String defaultBranch;
    private boolean firstPull = true;

    public void init() throws Exception {
        this.initialiseGitRepo();
        long timePeriod = this.getPullTimePeriod();
        if (timePeriod > 0L && this.isPullBeforeOperation()) {
            Timer t = this.getTimer();
            if (t == null) {
                t = new Timer();
                this.setTimer(t);
            }
            final Callable<Object> emptyCallable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Pulled from remote repository " + GitFacade.this.getRemoteRepository());
                    }
                    return null;
                }
            };
            this.task = new TimerTask(){

                public void run() {
                    try {
                        GitFacade.this.gitOperation(GitFacade.this.getStashPersonIdent(), emptyCallable);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to pull from remote repo " + e, (Throwable)e);
                    }
                }
            };
            t.schedule(this.task, timePeriod, timePeriod);
        }
        super.init();
    }

    public void destroy() throws Exception {
        if (this.task != null) {
            this.task.cancel();
        }
        super.destroy();
    }

    public PersonIdent getStashPersonIdent() {
        if (this.stashPersonIdent == null) {
            this.stashPersonIdent = new PersonIdent("dummy", "dummy");
        }
        return this.stashPersonIdent;
    }

    public void setStashPersonIdent(PersonIdent stashPersonIdent) {
        this.stashPersonIdent = stashPersonIdent;
    }

    public String getRemoteRepository() {
        if (this.remoteRepository == null) {
            this.remoteRepository = this.defaultRemoteRepository;
        }
        return this.remoteRepository;
    }

    public void setRemoteRepository(String remoteRepository) {
        Repository repository;
        this.remoteRepository = remoteRepository;
        if (this.git != null && Strings.isNotBlank((String)remoteRepository) && (repository = this.git.getRepository()) != null) {
            StoredConfig config = repository.getConfig();
            String origin = this.getRemote();
            config.setString("remote", origin, "url", remoteRepository);
            config.setString("remote", origin, "fetch", "+refs/heads/*:refs/remotes/" + origin + "/*");
            try {
                config.save();
            }
            catch (IOException e) {
                LOG.error("Failed to save the git configuration to " + this.getConfigDirName() + " with remote repo: " + remoteRepository + ". " + e, (Throwable)e);
            }
        }
    }

    public String getRemote() {
        return this.remote;
    }

    public void setRemote(String remote) {
        this.remote = remote;
    }

    public String getConfigDirName() {
        return this.configDirName;
    }

    public void setConfigDirName(String configDirName) {
        this.configDirName = configDirName;
    }

    public String getDefaultRemoteRepository() {
        return this.defaultRemoteRepository;
    }

    public void setDefaultRemoteRepository(String defaultRemoteRepository) {
        this.defaultRemoteRepository = defaultRemoteRepository;
    }

    public boolean isPullOnStartup() {
        return this.pullOnStartup;
    }

    public void setPullOnStartup(boolean pullOnStartup) {
        this.pullOnStartup = pullOnStartup;
    }

    public boolean isCloneAllBranches() {
        return this.cloneAllBranches;
    }

    public void setCloneAllBranches(boolean cloneAllBranches) {
        this.cloneAllBranches = cloneAllBranches;
    }

    @Override
    public boolean isPushOnCommit() {
        return this.pushOnCommit;
    }

    public void setPushOnCommit(boolean pushOnCommit) {
        this.pushOnCommit = pushOnCommit;
    }

    public boolean isPullBeforeOperation() {
        return this.pullBeforeOperation;
    }

    public void setPullBeforeOperation(boolean pullBeforeOperation) {
        this.pullBeforeOperation = pullBeforeOperation;
    }

    public boolean isCloneRemoteRepoOnStartup() {
        return this.cloneRemoteRepoOnStartup;
    }

    public void setCloneRemoteRepoOnStartup(boolean cloneRemoteRepoOnStartup) {
        this.cloneRemoteRepoOnStartup = cloneRemoteRepoOnStartup;
    }

    public CredentialsProvider getCredentials() {
        return this.credentials;
    }

    public void setCredentials(CredentialsProvider credentials) {
        this.credentials = credentials;
    }

    public long getPullTimePeriod() {
        return this.pullTimePeriod;
    }

    public void setPullTimePeriod(long pullTimePeriod) {
        this.pullTimePeriod = pullTimePeriod;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    @Override
    public String getContent(String objectId, String blobPath) {
        return this.doGetContent(this.git, objectId, blobPath);
    }

    @Override
    public FileContents read(final String branch, final String pathOrEmpty) throws IOException, GitAPIException {
        return this.gitOperation(this.getStashPersonIdent(), new Callable<FileContents>(){

            @Override
            public FileContents call() throws Exception {
                return GitFacade.this.doRead(GitFacade.this.git, GitFacade.this.getRootGitDirectory(), branch, pathOrEmpty);
            }
        });
    }

    @Override
    public FileInfo exists(final String branch, final String pathOrEmpty) throws IOException, GitAPIException {
        return this.gitOperation(this.getStashPersonIdent(), new Callable<FileInfo>(){

            @Override
            public FileInfo call() throws Exception {
                File rootDir = GitFacade.this.getRootGitDirectory();
                return GitFacade.this.doExists(GitFacade.this.git, rootDir, branch, pathOrEmpty);
            }
        });
    }

    @Override
    public List<String> completePath(final String branch, final String completionText, final boolean directoriesOnly) {
        return this.gitOperation(this.getStashPersonIdent(), new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                File rootDir = GitFacade.this.getRootGitDirectory();
                return GitFacade.this.doCompletePath(GitFacade.this.git, rootDir, branch, completionText, directoriesOnly);
            }
        });
    }

    @Override
    public String readJsonChildContent(final String branch, final String path, String fileNameWildcardOrBlank, final String search) throws IOException {
        final String fileNameWildcard = Strings.isBlank((String)fileNameWildcardOrBlank) ? "*.json" : fileNameWildcardOrBlank;
        return this.gitOperation(this.getStashPersonIdent(), new Callable<String>(){

            @Override
            public String call() throws Exception {
                File rootDir = GitFacade.this.getRootGitDirectory();
                return GitFacade.this.doReadJsonChildContent(GitFacade.this.git, rootDir, branch, path, fileNameWildcard, search);
            }
        });
    }

    @Override
    public CommitInfo write(final String branch, final String path, final String commitMessage, String authorName, String authorEmail, final String contents) {
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        return this.gitOperation(personIdent, new Callable<CommitInfo>(){

            @Override
            public CommitInfo call() throws Exception {
                GitFacade.this.checkoutBranch(GitFacade.this.git, branch);
                File rootDir = GitFacade.this.getRootGitDirectory();
                return GitFacade.this.doWrite(GitFacade.this.git, rootDir, branch, path, contents, personIdent, commitMessage);
            }
        });
    }

    @Override
    public CommitInfo createDirectory(final String branch, final String path, final String commitMessage, String authorName, String authorEmail) {
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        return this.gitOperation(personIdent, new Callable<CommitInfo>(){

            @Override
            public CommitInfo call() throws Exception {
                GitFacade.this.checkoutBranch(GitFacade.this.git, branch);
                File rootDir = GitFacade.this.getRootGitDirectory();
                return GitFacade.this.doCreateDirectory(GitFacade.this.git, rootDir, branch, path, personIdent, commitMessage);
            }
        });
    }

    @Override
    public void revertTo(final String branch, final String objectId, final String blobPath, final String commitMessage, String authorName, String authorEmail) {
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        this.gitOperation(personIdent, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Git aGit = GitFacade.this.git;
                File rootDir = GitFacade.this.getRootGitDirectory();
                return GitFacade.this.doRevert(aGit, rootDir, branch, objectId, blobPath, commitMessage, personIdent);
            }
        });
    }

    @Override
    public void rename(final String branch, final String oldPath, final String newPath, final String commitMessage, String authorName, String authorEmail) {
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        this.gitOperation(personIdent, new Callable<RevCommit>(){

            @Override
            public RevCommit call() throws Exception {
                File rootDir = GitFacade.this.getRootGitDirectory();
                return GitFacade.this.doRename(GitFacade.this.git, rootDir, branch, oldPath, newPath, commitMessage, personIdent);
            }
        });
    }

    @Override
    public void remove(final String branch, final String path, final String commitMessage, String authorName, String authorEmail) {
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        this.gitOperation(personIdent, new Callable<RevCommit>(){

            @Override
            public RevCommit call() throws Exception {
                Git aGit = GitFacade.this.git;
                File rootDir = GitFacade.this.getRootGitDirectory();
                return GitFacade.this.doRemove(aGit, rootDir, branch, path, commitMessage, personIdent);
            }
        });
    }

    @Override
    public List<String> branches() {
        return this.gitOperation(this.getStashPersonIdent(), new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return GitFacade.this.doListBranches(GitFacade.this.git);
            }
        });
    }

    @Override
    protected Iterable<PushResult> doPush(Git git) throws Exception {
        return ((PushCommand)this.git.push().setCredentialsProvider(this.getCredentials())).setRemote(this.getRemote()).call();
    }

    @Override
    public String getHEAD() {
        return this.doGetHead(this.git);
    }

    @Override
    public List<CommitInfo> history(String branch, String objectId, String path, int limit) {
        try {
            return this.doHistory(this.git, branch, objectId, path, limit);
        }
        catch (Exception e) {
            throw new RuntimeIOException(e);
        }
    }

    public static Date getCommitDate(RevCommit commit) {
        if (commit == null) {
            return new Date(0L);
        }
        return new Date((long)commit.getCommitTime() * 1000L);
    }

    @Override
    public String diff(String objectId, String baseObjectId, String path) {
        return this.doDiff(this.git, objectId, baseObjectId, path);
    }

    public File getRootGitDirectory() {
        if (this.configDirectory == null) {
            try {
                String name = this.getConfigDirName();
                if (Strings.isNotBlank((String)name)) {
                    this.configDirectory = new File(name);
                } else {
                    File hawtioConfigDir;
                    ConfigFacade singleton = ConfigFacade.getSingleton();
                    if (singleton != null && (hawtioConfigDir = singleton.getConfigDirectory()).exists()) {
                        this.configDirectory = new File(hawtioConfigDir, "config");
                    }
                    if (this.configDirectory == null) {
                        File file = File.createTempFile("hawtio-", "");
                        file.delete();
                        this.configDirectory = new File(file, "config");
                        this.configDirectory.mkdirs();
                    }
                }
                LOG.info("hawtio using config directory: " + this.configDirectory);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        return this.configDirectory;
    }

    public void setConfigDirectory(File configDirectory) {
        this.configDirectory = configDirectory;
    }

    public void initialiseGitRepo() throws IOException, GitAPIException {
        File confDir = this.getRootGitDirectory();
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        File gitDir = new File(confDir, ".git");
        if (!gitDir.exists()) {
            String repo = this.getRemoteRepository();
            if (Strings.isNotBlank((String)repo) && this.isCloneRemoteRepoOnStartup()) {
                boolean cloneAll = this.isCloneAllBranches();
                LOG.info("Cloning git repo " + repo + " into directory " + confDir.getCanonicalPath() + " cloneAllBranches: " + cloneAll);
                CloneCommand command = ((CloneCommand)Git.cloneRepository().setCredentialsProvider(this.getCredentials())).setCloneAllBranches(cloneAll).setURI(repo).setDirectory(confDir).setRemote(this.remote);
                try {
                    this.git = command.call();
                    return;
                }
                catch (Throwable e) {
                    LOG.error("Failed to command remote repo " + repo + ". Reason: " + e, e);
                }
            } else if (!this.isCloneRemoteRepoOnStartup()) {
                LOG.info("Clone git repo on startup disabled");
            }
            InitCommand initCommand = Git.init();
            initCommand.setDirectory(confDir);
            this.git = initCommand.call();
            LOG.info("Initialised an empty git configuration repo at " + confDir.getCanonicalPath());
            String branch = this.git.getRepository().getBranch();
            this.configureBranch(branch);
        } else {
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(gitDir)).readEnvironment()).findGitDir()).build();
            this.git = new Git(repository);
            if (this.isPullOnStartup()) {
                this.doPull();
            } else {
                LOG.info("git pull from remote config repo on startup is disabled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPull() {
        CredentialsProvider cp = this.getCredentials();
        try {
            Repository repository = this.git.getRepository();
            StoredConfig config = repository.getConfig();
            String url = config.getString("remote", "origin", "url");
            if (Strings.isBlank((String)url)) {
                this.logPull("No remote repository defined for the git repository at " + this.getRootGitDirectory().getCanonicalPath() + " so not doing a pull");
                return;
            }
            String branch = repository.getBranch();
            String mergeUrl = config.getString("branch", branch, "merge");
            if (Strings.isBlank((String)mergeUrl)) {
                this.logPull("No merge spec for branch." + branch + ".merge in the git repository at " + this.getRootGitDirectory().getCanonicalPath() + " so not doing a pull");
                return;
            }
            this.logPull("Performing a pull in git repository " + this.getRootGitDirectory().getCanonicalPath() + " on remote URL: " + url);
            ((PullCommand)this.git.pull().setCredentialsProvider(cp)).setRebase(true).call();
        }
        catch (Throwable e) {
            String credText = "";
            if (cp instanceof UsernamePasswordCredentialsProvider) {
                // empty if block
            }
            LOG.error("Failed to pull from the remote git repo with credentials " + cp + ". Reason: " + e, e);
        }
        finally {
            this.firstPull = false;
        }
    }

    protected void logPull(String message) {
        if (this.firstPull) {
            LOG.info(message + ". Subsequent pull attempts will use debug logging");
        } else {
            LOG.debug(message);
        }
    }

    public Status status() {
        try {
            return this.git.status().call();
        }
        catch (GitAPIException e) {
            throw new RuntimeIOException((Exception)((Object)e));
        }
    }

    protected <T> T gitOperation(PersonIdent personIdent, Callable<T> callable) {
        Object object = this.lock;
        synchronized (object) {
            try {
                boolean hasHead = true;
                try {
                    this.git.log().all().call();
                    hasHead = this.git.getRepository().getAllRefs().containsKey("HEAD");
                }
                catch (NoHeadException e) {
                    hasHead = false;
                }
                if (hasHead) {
                    this.git.stashCreate().setPerson(personIdent).setWorkingDirectoryMessage("Stash before a write").setRef("HEAD").call();
                }
                if (this.isPullOnStartup() && this.isPullBeforeOperation() && Strings.isNotBlank((String)this.getRemoteRepository())) {
                    this.doPull();
                }
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    public String currentBranch() {
        try {
            return this.git.getRepository().getBranch();
        }
        catch (IOException e) {
            LOG.warn("Failed to get the current branch: " + e, (Throwable)e);
            return null;
        }
    }

    @Override
    protected void checkoutBranch(Git git, String branch) throws GitAPIException {
        String current = this.currentBranch();
        if (this.defaultBranch == null) {
            this.defaultBranch = current;
        }
        if (Strings.isBlank((String)branch)) {
            branch = this.defaultBranch;
        }
        if (Objects.equals((Object)current, (Object)branch)) {
            return;
        }
        CheckoutCommand command = git.checkout().setName(branch);
        boolean exists = this.localBranchExists(branch);
        if (!exists) {
            command = command.setCreateBranch(true).setForce(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(this.getRemote() + "/" + branch);
        }
        Ref ref = command.call();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checked out branch " + branch + " with results " + ref.getName());
        }
        this.configureBranch(branch);
    }

    protected void configureBranch(String branch) {
        StoredConfig config;
        if (Strings.isNotBlank((String)branch) && (Strings.isBlank((String)(config = this.git.getRepository().getConfig()).getString("branch", branch, "remote")) || Strings.isBlank((String)config.getString("branch", branch, "merge")))) {
            config.setString("branch", branch, "remote", this.getRemote());
            config.setString("branch", branch, "merge", "refs/heads/" + branch);
            try {
                config.save();
            }
            catch (IOException e) {
                LOG.error("Failed to save the git configuration to " + this.getConfigDirName() + " with branch " + branch + " on remote repo: " + this.remoteRepository + ". " + e, (Throwable)e);
            }
        }
    }

    protected boolean localBranchExists(String branch) throws GitAPIException {
        List list = this.git.branchList().call();
        String fullName = "refs/heads/" + branch;
        boolean localBranchExists = false;
        for (Ref ref : list) {
            String name = ref.getName();
            if (!Objects.equals((Object)name, (Object)fullName)) continue;
            localBranchExists = true;
        }
        return localBranchExists;
    }
}

