/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.gitective.core.PersonComparator;
import org.gitective.core.filter.commit.CommitFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersonSetFilter
extends CommitFilter {
    protected final Set<PersonIdent> persons;

    public PersonSetFilter() {
        this(new PersonComparator());
    }

    public PersonSetFilter(Comparator<PersonIdent> comparator) {
        this.persons = new TreeSet<PersonIdent>(comparator);
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        PersonIdent person = this.getPerson(commit);
        if (person != null) {
            this.persons.add(person);
        }
        return true;
    }

    @Override
    public CommitFilter reset() {
        this.persons.clear();
        return super.reset();
    }

    public Set<PersonIdent> getPersons() {
        return this.persons;
    }

    protected abstract PersonIdent getPerson(RevCommit var1);
}

