/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core;

import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gitective.core.Assert;
import org.gitective.core.CommitUtils;
import org.gitective.core.GitException;

public abstract class TreeUtils {
    protected static RevTree getTree(RevWalk walk, RevCommit commit) throws IOException {
        RevTree tree = commit.getTree();
        if (tree != null) {
            return tree;
        }
        walk.parseHeaders((RevObject)commit);
        return commit.getTree();
    }

    protected static TreeWalk withParents(ObjectReader reader, RevWalk rWalk, RevCommit commit) throws IOException {
        TreeWalk walk = new TreeWalk(reader);
        int parentCount = commit.getParentCount();
        switch (parentCount) {
            case 0: {
                walk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                break;
            }
            case 1: {
                walk.addTree((AnyObjectId)TreeUtils.getTree(rWalk, commit.getParent(0)));
                break;
            }
            default: {
                RevCommit[] parents = commit.getParents();
                for (int i = 0; i < parentCount; ++i) {
                    walk.addTree((AnyObjectId)TreeUtils.getTree(rWalk, parents[i]));
                }
            }
        }
        walk.addTree((AnyObjectId)TreeUtils.getTree(rWalk, commit));
        return walk;
    }

    public static TreeWalk withParents(Repository repository, AnyObjectId commitId) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (commitId == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commit id"));
        }
        ObjectReader reader = repository.newObjectReader();
        RevWalk walk = new RevWalk(reader);
        try {
            return TreeUtils.withParents(reader, walk, walk.parseCommit(commitId));
        }
        catch (IOException e) {
            walk.release();
            throw new GitException(e, repository);
        }
    }

    public static TreeWalk withParents(Repository repository, String revision) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revision"));
        }
        if (revision.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revision"));
        }
        ObjectId commit = CommitUtils.strictResolve(repository, revision);
        ObjectReader reader = repository.newObjectReader();
        RevWalk walk = new RevWalk(reader);
        try {
            return TreeUtils.withParents(reader, walk, walk.parseCommit((AnyObjectId)commit));
        }
        catch (IOException e) {
            walk.release();
            throw new GitException(e, repository);
        }
    }

    public static TreeWalk withParents(RevWalk walk, RevCommit commit) {
        if (walk == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Walk"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commit"));
        }
        try {
            return TreeUtils.withParents(walk.getObjectReader(), walk, commit);
        }
        catch (IOException e) {
            throw new GitException(e, null);
        }
    }

    public static TreeWalk diffWithParents(Repository repository, AnyObjectId commitId) {
        TreeWalk walk = TreeUtils.withParents(repository, commitId);
        walk.setFilter(TreeFilter.ANY_DIFF);
        return walk;
    }

    public static TreeWalk diffWithParents(RevWalk walk, RevCommit commit) {
        TreeWalk treeWalk = TreeUtils.withParents(walk, commit);
        treeWalk.setFilter(TreeFilter.ANY_DIFF);
        return treeWalk;
    }

    public static TreeWalk diffWithParents(Repository repository, String revision) {
        TreeWalk walk = TreeUtils.withParents(repository, revision);
        walk.setFilter(TreeFilter.ANY_DIFF);
        return walk;
    }

    public static TreeWalk withCommits(Repository repository, String ... revisions) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revisions == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revisions"));
        }
        if (revisions.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revisions"));
        }
        TreeWalk walk = new TreeWalk(repository);
        try {
            for (String revision : revisions) {
                walk.addTree((AnyObjectId)CommitUtils.getCommit(repository, revision).getTree());
            }
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        return walk;
    }

    public static TreeWalk withCommits(Repository repository, ObjectId ... commits) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commits"));
        }
        if (commits.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Commits"));
        }
        TreeWalk walk = new TreeWalk(repository);
        try {
            for (ObjectId commit : commits) {
                walk.addTree((AnyObjectId)CommitUtils.getCommit(repository, commit).getTree());
            }
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        return walk;
    }

    public static TreeWalk diffWithCommits(Repository repository, ObjectId ... commits) {
        TreeWalk walk = TreeUtils.withCommits(repository, commits);
        walk.setFilter(TreeFilter.ANY_DIFF);
        return walk;
    }

    public static TreeWalk diffWithCommits(Repository repository, String ... revisions) {
        TreeWalk walk = TreeUtils.withCommits(repository, revisions);
        walk.setFilter(TreeFilter.ANY_DIFF);
        return walk;
    }

    protected static ObjectId lookupId(Repository repository, RevCommit commit, String path) {
        TreeWalk walk;
        try {
            walk = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)commit.getTree());
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        if (walk == null) {
            return null;
        }
        if ((walk.getRawMode(0) & 0xF000) != 16384) {
            return null;
        }
        return walk.getObjectId(0);
    }

    public static ObjectId getId(Repository repository, ObjectId commitId, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (commitId == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commit Id"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        RevCommit commit = CommitUtils.parse(repository, commitId);
        return TreeUtils.lookupId(repository, commit, path);
    }

    public static ObjectId getId(Repository repository, String revision, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revision"));
        }
        if (revision.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revision"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        RevCommit commit = CommitUtils.parse(repository, CommitUtils.strictResolve(repository, revision));
        return TreeUtils.lookupId(repository, commit, path);
    }

    public static boolean visit(Repository repository, ObjectId treeId, ITreeVisitor visitor) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (treeId == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Tree Id"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Visitor"));
        }
        TreeWalk walk = new TreeWalk(repository);
        MutableObjectId id = new MutableObjectId();
        String path = null;
        try {
            walk.addTree((AnyObjectId)treeId);
            while (walk.next()) {
                walk.getObjectId(id, 0);
                if (!visitor.accept(walk.getFileMode(0), path, walk.getNameString(), (AnyObjectId)id)) {
                    boolean bl = false;
                    return bl;
                }
                if (!walk.isSubtree()) continue;
                path = walk.getPathString();
                walk.enterSubtree();
            }
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        finally {
            walk.release();
        }
        return true;
    }

    public static interface ITreeVisitor {
        public boolean accept(FileMode var1, String var2, String var3, AnyObjectId var4);
    }
}

