/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.concurrent.ConcurrentHashMap;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FuncallableStandardObject;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public final class StandardGenericFunction
extends FuncallableStandardObject {
    ConcurrentHashMap<CacheEntry, LispObject> cache;
    ConcurrentHashMap<LispObject, LispObject> slotCache;
    private static final Primitive _GENERIC_FUNCTION_NAME = new pf__generic_function_name();
    private static final Primitive _SET_GENERIC_FUNCTION_NAME = new pf__set_generic_function_name();
    private static final Primitive _GENERIC_FUNCTION_LAMBDA_LIST = new pf__generic_function_lambda_list();
    private static final Primitive _SET_GENERIC_FUNCTION_LAMBDA_LIST = new pf__set_generic_function_lambda_list();
    private static final Primitive GF_REQUIRED_ARGS = new pf_gf_required_args();
    private static final Primitive _SET_GF_REQUIRED_ARGS = new pf__set_gf_required_args();
    private static final Primitive GF_OPTIONAL_ARGS = new pf_gf_optional_args();
    private static final Primitive _SET_GF_OPTIONAL_ARGS = new pf__set_gf_optional_args();
    private static final Primitive GENERIC_FUNCTION_INITIAL_METHODS = new pf_generic_function_initial_methods();
    private static final Primitive SET_GENERIC_FUNCTION_INITIAL_METHODS = new pf_set_generic_function_initial_methods();
    private static final Primitive GENERIC_FUNCTION_METHODS = new pf_generic_function_methods();
    private static final Primitive SET_GENERIC_FUNCTION_METHODS = new pf_set_generic_function_methods();
    private static final Primitive GENERIC_FUNCTION_METHOD_CLASS = new pf_generic_function_method_class();
    private static final Primitive SET_GENERIC_FUNCTION_METHOD_CLASS = new pf_set_generic_function_method_class();
    private static final Primitive GENERIC_FUNCTION_METHOD_COMBINATION = new pf_generic_function_method_combination();
    private static final Primitive SET_GENERIC_FUNCTION_METHOD_COMBINATION = new pf_set_generic_function_method_combination();
    private static final Primitive GENERIC_FUNCTION_ARGUMENT_PRECEDENCE_ORDER = new pf_generic_function_argument_precedence_order();
    private static final Primitive SET_GENERIC_FUNCTION_ARGUMENT_PRECEDENCE_ORDER = new pf_set_generic_function_argument_precedence_order();
    private static final Primitive GENERIC_FUNCTION_DECLARATIONS = new pf_generic_function_declarations();
    private static final Primitive SET_GENERIC_FUNCTION_DECLARATIONS = new pf_set_generic_function_declarations();
    private static final Primitive GENERIC_FUNCTION_CLASSES_TO_EMF_TABLE = new pf_generic_function_classes_to_emf_table();
    private static final Primitive SET_GENERIC_FUNCTION_CLASSES_TO_EMF_TABLE = new pf_set_generic_function_classes_to_emf_table();
    private static final Primitive GENERIC_FUNCTION_DOCUMENTATION = new pf_generic_function_documentation();
    private static final Primitive SET_GENERIC_FUNCTION_DOCUMENTATION = new pf_set_generic_function_documentation();
    private static final Primitive _FINALIZE_GENERIC_FUNCTION = new pf__finalize_generic_function();
    private static final Primitive CACHE_EMF = new pf_cache_emf();
    private static final Primitive GET_CACHED_EMF = new pf_get_cached_emf();
    private static final Primitive _GET_ARG_SPECIALIZATION = new pf__get_arg_specialization();
    private static final Primitive CACHE_SLOT_LOCATION = new pf_cache_slot_location();
    private static final Primitive GET_CACHED_SLOT_LOCATION = new pf_get_cached_slot_location();
    EqlSpecialization[] eqlSpecializations = new EqlSpecialization[0];
    private static final Primitive _INIT_EQL_SPECIALIZATIONS = new pf__init_eql_specializations();

    public StandardGenericFunction() {
        super(StandardClass.STANDARD_GENERIC_FUNCTION, StandardClass.STANDARD_GENERIC_FUNCTION.getClassLayout().getLength());
    }

    public StandardGenericFunction(Layout layout) {
        super(layout);
        this.slots[0] = Lisp.NIL;
        this.slots[1] = Lisp.NIL;
        this.slots[2] = Lisp.NIL;
        this.slots[3] = Lisp.NIL;
        this.slots[4] = Lisp.NIL;
        this.slots[5] = Lisp.NIL;
        this.slots[6] = StandardClass.STANDARD_METHOD;
        this.slots[7] = Lisp.list(Symbol.STANDARD, new LispObject[0]);
        this.slots[8] = Lisp.NIL;
        this.slots[9] = Lisp.NIL;
        this.slots[10] = Lisp.NIL;
        this.slots[11] = Lisp.NIL;
    }

    void finalizeInternal() {
        this.cache = null;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.COMPILED_FUNCTION) {
            if (this.function != null) {
                return this.function.typep(type);
            }
            return Lisp.NIL;
        }
        if (type == Symbol.STANDARD_GENERIC_FUNCTION) {
            return Lisp.T;
        }
        if (type == StandardClass.STANDARD_GENERIC_FUNCTION) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject getGenericFunctionName() {
        return this.slots[0];
    }

    public void setGenericFunctionName(LispObject name) {
        this.slots[0] = name;
    }

    public String printObject() {
        LispObject name = this.getGenericFunctionName();
        if (name != null) {
            StringBuilder sb = new StringBuilder();
            LispObject lispClass = this.getLispClass();
            LispObject className = lispClass instanceof LispClass ? ((LispClass)lispClass).getName() : Symbol.CLASS_NAME.execute(lispClass);
            sb.append(className.princToString());
            sb.append(' ');
            sb.append(name.princToString());
            return this.unreadableString(sb.toString());
        }
        return super.printObject();
    }

    LispObject getArgSpecialization(LispObject arg) {
        for (EqlSpecialization eqlSpecialization : this.eqlSpecializations) {
            if (!eqlSpecialization.eqlTo.eql(arg)) continue;
            return eqlSpecialization;
        }
        return arg.classOf();
    }

    public static final StandardGenericFunction checkStandardGenericFunction(LispObject obj) {
        if (obj instanceof StandardGenericFunction) {
            return (StandardGenericFunction)obj;
        }
        return (StandardGenericFunction)Lisp.type_error(obj, Symbol.STANDARD_GENERIC_FUNCTION);
    }

    private static class EqlSpecialization
    extends LispObject {
        public LispObject eqlTo;

        public EqlSpecialization(LispObject eqlTo) {
            this.eqlTo = eqlTo;
        }
    }

    @DocString(name="%init-eql-specializations", args="generic-function eql-specilizer-objects-list")
    private static final class pf__init_eql_specializations
    extends Primitive {
        pf__init_eql_specializations() {
            super("%init-eql-specializations", Lisp.PACKAGE_SYS, true, "generic-function eql-specilizer-objects-list");
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject eqlSpecializerObjects = second;
            gf.eqlSpecializations = new EqlSpecialization[eqlSpecializerObjects.length()];
            for (int i = 0; i < gf.eqlSpecializations.length; ++i) {
                gf.eqlSpecializations[i] = new EqlSpecialization(eqlSpecializerObjects.car());
                eqlSpecializerObjects = eqlSpecializerObjects.cdr();
            }
            return Lisp.NIL;
        }
    }

    private static class CacheEntry {
        final LispObject[] array;

        CacheEntry(LispObject[] array) {
            this.array = array;
        }

        public int hashCode() {
            int result = 0;
            int i = this.array.length;
            while (i-- > 0) {
                result ^= this.array[i].hashCode();
            }
            return result;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheEntry)) {
                return false;
            }
            CacheEntry otherEntry = (CacheEntry)object;
            if (otherEntry.array.length != this.array.length) {
                return false;
            }
            LispObject[] otherArray = otherEntry.array;
            int i = this.array.length;
            while (i-- > 0) {
                if (this.array[i] == otherArray[i]) continue;
                return false;
            }
            return true;
        }
    }

    @DocString(name="get-cached-slot-location")
    private static final class pf_get_cached_slot_location
    extends Primitive {
        pf_get_cached_slot_location() {
            super("get-cached-slot-location", Lisp.PACKAGE_SYS, true, "generic-function layout");
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject layout = second;
            ConcurrentHashMap<LispObject, LispObject> ht = gf.slotCache;
            if (ht == null) {
                return Lisp.NIL;
            }
            LispObject location = ht.get(layout);
            return location != null ? location : Lisp.NIL;
        }
    }

    @DocString(name="cache-slot-location", args="generic-function layout location")
    private static final class pf_cache_slot_location
    extends Primitive {
        pf_cache_slot_location() {
            super("cache-slot-location", Lisp.PACKAGE_SYS, true, "generic-function layout location");
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject layout = second;
            LispObject location = third;
            ConcurrentHashMap<LispObject, LispObject> ht = gf.slotCache;
            if (ht == null) {
                ht = gf.slotCache = new ConcurrentHashMap();
            }
            ht.put(layout, location);
            return third;
        }
    }

    @DocString(name="%get-arg-specialization", args="generic-function arg")
    private static final class pf__get_arg_specialization
    extends Primitive {
        pf__get_arg_specialization() {
            super("%get-arg-specialization", Lisp.PACKAGE_SYS, true, "generic-function arg");
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            return gf.getArgSpecialization(second);
        }
    }

    @DocString(name="get-cached-emf", args="generic-function args")
    private static final class pf_get_cached_emf
    extends Primitive {
        pf_get_cached_emf() {
            super("get-cached-emf", Lisp.PACKAGE_SYS, true, "generic-function args");
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject args = second;
            int numberOfRequiredArgs = gf.slots[2].length();
            LispObject[] array = new LispObject[numberOfRequiredArgs];
            int i = numberOfRequiredArgs;
            while (i-- > 0) {
                array[i] = gf.getArgSpecialization(args.car());
                args = args.cdr();
            }
            CacheEntry specializations = new CacheEntry(array);
            ConcurrentHashMap<CacheEntry, LispObject> ht = gf.cache;
            if (ht == null) {
                return Lisp.NIL;
            }
            LispObject emf = ht.get(specializations);
            return emf != null ? emf : Lisp.NIL;
        }
    }

    @DocString(name="cache-emf", args="generic-function args emf")
    private static final class pf_cache_emf
    extends Primitive {
        pf_cache_emf() {
            super("cache-emf", Lisp.PACKAGE_SYS, true, "generic-function args emf");
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            LispObject args = second;
            int numberOfRequiredArgs = gf.slots[2].length();
            LispObject[] array = new LispObject[numberOfRequiredArgs];
            int i = numberOfRequiredArgs;
            while (i-- > 0) {
                array[i] = gf.getArgSpecialization(args.car());
                args = args.cdr();
            }
            CacheEntry specializations = new CacheEntry(array);
            ConcurrentHashMap<CacheEntry, LispObject> ht = gf.cache;
            if (ht == null) {
                ht = gf.cache = new ConcurrentHashMap();
            }
            ht.put(specializations, third);
            return third;
        }
    }

    @DocString(name="%finalize-generic-function", args="generic-function")
    private static final class pf__finalize_generic_function
    extends Primitive {
        pf__finalize_generic_function() {
            super("%finalize-generic-function", Lisp.PACKAGE_SYS, true, "generic-function");
        }

        public LispObject execute(LispObject arg) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(arg);
            gf.finalizeInternal();
            return Lisp.T;
        }
    }

    @DocString(name="set-generic-function-documentation")
    private static final class pf_set_generic_function_documentation
    extends Primitive {
        pf_set_generic_function_documentation() {
            super("set-generic-function-documentation", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[11] = second;
            return second;
        }
    }

    @DocString(name="generic-function-documentation")
    private static final class pf_generic_function_documentation
    extends Primitive {
        pf_generic_function_documentation() {
            super("generic-function-documentation", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[11];
        }
    }

    @DocString(name="set-generic-function-classes-to-emf-table")
    private static final class pf_set_generic_function_classes_to_emf_table
    extends Primitive {
        pf_set_generic_function_classes_to_emf_table() {
            super("set-generic-function-classes-to-emf-table", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[10] = second;
            return second;
        }
    }

    @DocString(name="generic-function-classes-to-emf-table")
    private static final class pf_generic_function_classes_to_emf_table
    extends Primitive {
        pf_generic_function_classes_to_emf_table() {
            super("generic-function-classes-to-emf-table", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[10];
        }
    }

    @DocString(name="set-generic-function-declarations")
    private static final class pf_set_generic_function_declarations
    extends Primitive {
        pf_set_generic_function_declarations() {
            super("set-generic-function-declarations", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[9] = second;
            return second;
        }
    }

    @DocString(name="%generic-function-declarations")
    private static final class pf_generic_function_declarations
    extends Primitive {
        pf_generic_function_declarations() {
            super("%generic-function-declarations", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[9];
        }
    }

    @DocString(name="set-generic-function-argument-precedence-order")
    private static final class pf_set_generic_function_argument_precedence_order
    extends Primitive {
        pf_set_generic_function_argument_precedence_order() {
            super("set-generic-function-argument-precedence-order", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[8] = second;
            return second;
        }
    }

    @DocString(name="%generic-function-argument-precedence-order")
    private static final class pf_generic_function_argument_precedence_order
    extends Primitive {
        pf_generic_function_argument_precedence_order() {
            super("%generic-function-argument-precedence-order", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[8];
        }
    }

    @DocString(name="set-generic-function-method-combination")
    private static final class pf_set_generic_function_method_combination
    extends Primitive {
        pf_set_generic_function_method_combination() {
            super("set-generic-function-method-combination", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[7] = second;
            return second;
        }
    }

    @DocString(name="%generic-function-method-combination")
    private static final class pf_generic_function_method_combination
    extends Primitive {
        pf_generic_function_method_combination() {
            super("%generic-function-method-combination", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[7];
        }
    }

    @DocString(name="set-generic-function-method-class")
    private static final class pf_set_generic_function_method_class
    extends Primitive {
        pf_set_generic_function_method_class() {
            super("set-generic-function-method-class", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[6] = second;
            return second;
        }
    }

    @DocString(name="%generic-function-method-class")
    private static final class pf_generic_function_method_class
    extends Primitive {
        pf_generic_function_method_class() {
            super("%generic-function-method-class", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[6];
        }
    }

    @DocString(name="set-generic-function-methods")
    private static final class pf_set_generic_function_methods
    extends Primitive {
        pf_set_generic_function_methods() {
            super("set-generic-function-methods", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[5] = second;
            return second;
        }
    }

    @DocString(name="%generic-function-methods")
    private static final class pf_generic_function_methods
    extends Primitive {
        pf_generic_function_methods() {
            super("%generic-function-methods", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[5];
        }
    }

    @DocString(name="set-generic-function-initial-methods")
    private static final class pf_set_generic_function_initial_methods
    extends Primitive {
        pf_set_generic_function_initial_methods() {
            super("set-generic-function-initial-methods", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[4] = second;
            return second;
        }
    }

    @DocString(name="generic-function-initial-methods")
    private static final class pf_generic_function_initial_methods
    extends Primitive {
        pf_generic_function_initial_methods() {
            super("generic-function-initial-methods", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[4];
        }
    }

    @DocString(name="%set-gf-optional-args")
    private static final class pf__set_gf_optional_args
    extends Primitive {
        pf__set_gf_optional_args() {
            super("%set-gf-optional-args", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            gf.slots[3] = second;
            return second;
        }
    }

    @DocString(name="gf-optional-args")
    private static final class pf_gf_optional_args
    extends Primitive {
        pf_gf_optional_args() {
            super("gf-optional-args", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[3];
        }
    }

    @DocString(name="%set-gf-required-args")
    private static final class pf__set_gf_required_args
    extends Primitive {
        pf__set_gf_required_args() {
            super("%set-gf-required-args", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction gf = StandardGenericFunction.checkStandardGenericFunction(first);
            gf.slots[2] = second;
            return second;
        }
    }

    @DocString(name="gf-required-args")
    private static final class pf_gf_required_args
    extends Primitive {
        pf_gf_required_args() {
            super("gf-required-args", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[2];
        }
    }

    @DocString(name="%set-generic-function-lambdalist")
    private static final class pf__set_generic_function_lambda_list
    extends Primitive {
        pf__set_generic_function_lambda_list() {
            super("%set-generic-function-lambda-list", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[1] = second;
            return second;
        }
    }

    @DocString(name="%generic-function-lambda-list")
    private static final class pf__generic_function_lambda_list
    extends Primitive {
        pf__generic_function_lambda_list() {
            super("%generic-function-lambda-list", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[1];
        }
    }

    @DocString(name="%set-generic-function-name")
    private static final class pf__set_generic_function_name
    extends Primitive {
        pf__set_generic_function_name() {
            super("%set-generic-function-name", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            StandardGenericFunction.checkStandardGenericFunction((LispObject)first).slots[0] = second;
            return second;
        }
    }

    @DocString(name="%generic-function-name")
    private static final class pf__generic_function_name
    extends Primitive {
        pf__generic_function_name() {
            super("%generic-function-name", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            return StandardGenericFunction.checkStandardGenericFunction((LispObject)arg).slots[0];
        }
    }
}

