/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SlotDefinition;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public class SlotClass
extends LispClass {
    private LispObject directSlotDefinitions = Lisp.NIL;
    private LispObject slotDefinitions = Lisp.NIL;
    private LispObject directDefaultInitargs = Lisp.NIL;
    private LispObject defaultInitargs = Lisp.NIL;
    @DocString(name="%class-direct-slots")
    private static final Primitive CLASS_DIRECT_SLOTS = new pf__class_direct_slots();
    @DocString(name="%set-class-direct-slots")
    private static final Primitive _SET_CLASS_DIRECT_SLOT = new pf__set_class_direct_slots();
    @DocString(name="%class-slots", args="class")
    private static final Primitive _CLASS_SLOTS = new pf__class_slots();
    @DocString(name="%set-class-slots", args="class slot-definitions")
    private static final Primitive _SET_CLASS_SLOTS = new pf__set_class_slots();
    @DocString(name="%class-direct-default-initargs")
    private static final Primitive CLASS_DIRECT_DEFAULT_INITARGS = new pf__class_direct_default_initargs();
    @DocString(name="%set-class-direct-default-initargs")
    private static final Primitive _SET_CLASS_DIRECT_DEFAULT_INITARGS = new pf__set_class_direct_default_initargs();
    @DocString(name="%class-default-initargs")
    private static final Primitive CLASS_DEFAULT_INITARGS = new pf__class_default_initargs();
    @DocString(name="%set-class-default-initargs")
    private static final Primitive _SET_CLASS_DEFAULT_INITARGS = new pf__set_class_default_initargs();

    public SlotClass(Layout layout) {
        super(layout);
    }

    public SlotClass(Symbol symbol, LispObject directSuperclasses) {
        this(null, symbol, directSuperclasses);
    }

    public SlotClass(Layout layout, Symbol symbol, LispObject directSuperclasses) {
        super(layout, symbol, directSuperclasses);
    }

    public LispObject getParts() {
        LispObject result = super.getParts().nreverse();
        result = result.push(new Cons("DIRECT-SLOTS", this.getDirectSlotDefinitions()));
        result = result.push(new Cons("SLOTS", this.getSlotDefinitions()));
        result = result.push(new Cons("DIRECT-DEFAULT-INITARGS", this.getDirectDefaultInitargs()));
        result = result.push(new Cons("DEFAULT-INITARGS", this.getDefaultInitargs()));
        return result.nreverse();
    }

    public LispObject typep(LispObject type) {
        return super.typep(type);
    }

    public LispObject getDirectSlotDefinitions() {
        return this.directSlotDefinitions;
    }

    public void setDirectSlotDefinitions(LispObject directSlotDefinitions) {
        this.directSlotDefinitions = directSlotDefinitions;
    }

    public LispObject getSlotDefinitions() {
        return this.slotDefinitions;
    }

    public void setSlotDefinitions(LispObject slotDefinitions) {
        this.slotDefinitions = slotDefinitions;
    }

    public LispObject getDirectDefaultInitargs() {
        return this.directDefaultInitargs;
    }

    public void setDirectDefaultInitargs(LispObject directDefaultInitargs) {
        this.directDefaultInitargs = directDefaultInitargs;
    }

    public LispObject getDefaultInitargs() {
        return this.defaultInitargs;
    }

    public void setDefaultInitargs(LispObject defaultInitargs) {
        this.defaultInitargs = defaultInitargs;
    }

    LispObject computeDefaultInitargs() {
        LispObject result = Lisp.NIL;
        for (LispObject cpl = this.getCPL(); cpl != Lisp.NIL; cpl = cpl.cdr()) {
            LispObject obj;
            LispClass c = (LispClass)cpl.car();
            if (!(c instanceof StandardClass) || (obj = ((StandardClass)c).getDirectDefaultInitargs()) == Lisp.NIL) continue;
            result = Symbol.APPEND.execute(result, obj);
        }
        return result;
    }

    public void finalizeClass() {
        if (this.isFinalized()) {
            return;
        }
        LispObject defs = this.getSlotDefinitions();
        Debug.assertTrue(defs == Lisp.NIL);
        LispObject cpl = this.getCPL();
        Debug.assertTrue(cpl != null);
        Debug.assertTrue(cpl.listp());
        for (cpl = cpl.reverse(); cpl != Lisp.NIL; cpl = cpl.cdr()) {
            LispObject car = cpl.car();
            if (!(car instanceof StandardClass)) continue;
            StandardClass cls = (StandardClass)car;
            LispObject directDefs = cls.getDirectSlotDefinitions();
            Debug.assertTrue(directDefs != null);
            Debug.assertTrue(directDefs.listp());
            while (directDefs != Lisp.NIL) {
                defs = defs.push(directDefs.car());
                directDefs = directDefs.cdr();
            }
        }
        this.setSlotDefinitions(defs.nreverse());
        LispObject[] instanceSlotNames = new LispObject[defs.length()];
        int i = 0;
        for (LispObject tail = this.getSlotDefinitions(); tail != Lisp.NIL; tail = tail.cdr()) {
            SlotDefinition slotDefinition = (SlotDefinition)tail.car();
            SlotDefinition.SET_SLOT_DEFINITION_LOCATION.execute((LispObject)slotDefinition, Fixnum.getInstance(i));
            instanceSlotNames[i++] = SlotDefinition._SLOT_DEFINITION_NAME.execute(slotDefinition);
        }
        this.setClassLayout(new Layout((LispObject)this, instanceSlotNames, (LispObject)Lisp.NIL));
        this.setDefaultInitargs(this.computeDefaultInitargs());
        this.setFinalized(true);
    }

    private static final class pf__set_class_default_initargs
    extends Primitive {
        pf__set_class_default_initargs() {
            super("%set-class-default-initargs", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (second instanceof SlotClass) {
                ((SlotClass)second).setDefaultInitargs(first);
                return first;
            }
            return Lisp.type_error(second, Symbol.STANDARD_CLASS);
        }
    }

    private static final class pf__class_default_initargs
    extends Primitive {
        pf__class_default_initargs() {
            super("%class-default-initargs", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof SlotClass) {
                return ((SlotClass)arg).getDefaultInitargs();
            }
            if (arg instanceof BuiltInClass) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    }

    private static final class pf__set_class_direct_default_initargs
    extends Primitive {
        pf__set_class_direct_default_initargs() {
            super("%set-class-direct-default-initargs", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (second instanceof SlotClass) {
                ((SlotClass)second).setDirectDefaultInitargs(first);
                return first;
            }
            return Lisp.type_error(second, Symbol.STANDARD_CLASS);
        }
    }

    private static final class pf__class_direct_default_initargs
    extends Primitive {
        pf__class_direct_default_initargs() {
            super("%class-direct-default-initargs", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof SlotClass) {
                return ((SlotClass)arg).getDirectDefaultInitargs();
            }
            if (arg instanceof BuiltInClass) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    }

    private static final class pf__set_class_slots
    extends Primitive {
        pf__set_class_slots() {
            super(Symbol._SET_CLASS_SLOTS, "class slot-definitions");
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (second instanceof SlotClass) {
                ((SlotClass)second).setSlotDefinitions(first);
                return first;
            }
            return Lisp.type_error(second, Symbol.STANDARD_CLASS);
        }
    }

    private static final class pf__class_slots
    extends Primitive {
        pf__class_slots() {
            super(Symbol._CLASS_SLOTS, "class");
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof SlotClass) {
                return ((SlotClass)arg).getSlotDefinitions();
            }
            if (arg instanceof BuiltInClass) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    }

    private static final class pf__set_class_direct_slots
    extends Primitive {
        pf__set_class_direct_slots() {
            super("%set-class-direct-slots", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (second instanceof SlotClass) {
                ((SlotClass)second).setDirectSlotDefinitions(first);
                return first;
            }
            return Lisp.type_error(second, Symbol.STANDARD_CLASS);
        }
    }

    private static final class pf__class_direct_slots
    extends Primitive {
        pf__class_direct_slots() {
            super("%class-direct-slots", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof SlotClass) {
                return ((SlotClass)arg).getDirectSlotDefinitions();
            }
            if (arg instanceof BuiltInClass) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    }
}

