require '_h2ph_pre.ph';

no warnings qw(redefine misc);

eval 'sub BT_ADDR () {0x;}' unless defined(&BT_ADDR);
eval 'sub BT_CMAP () {0x4;}' unless defined(&BT_CMAP);
eval 'sub BT_CTRL () {0x8;}' unless defined(&BT_CTRL);
eval 'sub BT_OMAP () {0xc;}' unless defined(&BT_OMAP);
unless(defined(&BT_D4M3)) {
    sub BT_D4M3 {
	my($x) = @_;
	eval q((((($x) >> 2) << 1) + (($x) >> 2)));
    }
}
unless(defined(&BT_D4M4)) {
    sub BT_D4M4 {
	my($x) = @_;
	eval q((($x) & ~3));
    }
}
eval 'sub CGSIX_ROM_OFFSET () {0x;}' unless defined(&CGSIX_ROM_OFFSET);
eval 'sub CGSIX_BT_OFFSET () {0x200000;}' unless defined(&CGSIX_BT_OFFSET);
eval 'sub CGSIX_BT_SIZE () {($sizeof{ &u_int32_t} * 4);}' unless defined(&CGSIX_BT_SIZE);
eval 'sub CGSIX_DHC_OFFSET () {0x240000;}' unless defined(&CGSIX_DHC_OFFSET);
eval 'sub CGSIX_ALT_OFFSET () {0x280000;}' unless defined(&CGSIX_ALT_OFFSET);
eval 'sub CGSIX_FHC_OFFSET () {0x300000;}' unless defined(&CGSIX_FHC_OFFSET);
eval 'sub CGSIX_FHC_SIZE () {($sizeof{ &u_int32_t} * 1);}' unless defined(&CGSIX_FHC_SIZE);
eval 'sub CGSIX_THC_OFFSET () {0x301000;}' unless defined(&CGSIX_THC_OFFSET);
eval 'sub CGSIX_THC_SIZE () {($sizeof{ &u_int32_t} * 640);}' unless defined(&CGSIX_THC_SIZE);
eval 'sub CGSIX_FBC_OFFSET () {0x700000;}' unless defined(&CGSIX_FBC_OFFSET);
eval 'sub CGSIX_FBC_SIZE () {0x1000;}' unless defined(&CGSIX_FBC_SIZE);
eval 'sub CGSIX_TEC_OFFSET () {0x701000;}' unless defined(&CGSIX_TEC_OFFSET);
eval 'sub CGSIX_TEC_SIZE () {($sizeof{ &u_int32_t} * 3);}' unless defined(&CGSIX_TEC_SIZE);
eval 'sub CGSIX_VID_OFFSET () {0x800000;}' unless defined(&CGSIX_VID_OFFSET);
eval 'sub CGSIX_VID_SIZE () {(1024* 1024);}' unless defined(&CGSIX_VID_SIZE);
eval 'sub CG6_FHC () {0x;}' unless defined(&CG6_FHC);
eval 'sub FHC_FBID_MASK () {0xff000000;}' unless defined(&FHC_FBID_MASK);
eval 'sub FHC_FBID_SHIFT () {24;}' unless defined(&FHC_FBID_SHIFT);
eval 'sub FHC_REV_MASK () {0xf00000;}' unless defined(&FHC_REV_MASK);
eval 'sub FHC_REV_SHIFT () {20;}' unless defined(&FHC_REV_SHIFT);
eval 'sub FHC_FROP_DISABLE () {0x80000;}' unless defined(&FHC_FROP_DISABLE);
eval 'sub FHC_ROW_DISABLE () {0x40000;}' unless defined(&FHC_ROW_DISABLE);
eval 'sub FHC_SRC_DISABLE () {0x20000;}' unless defined(&FHC_SRC_DISABLE);
eval 'sub FHC_DST_DISABLE () {0x10000;}' unless defined(&FHC_DST_DISABLE);
eval 'sub FHC_RESET () {0x8000;}' unless defined(&FHC_RESET);
eval 'sub FHC_LEBO () {0x2000;}' unless defined(&FHC_LEBO);
eval 'sub FHC_RES_MASK () {0x1800;}' unless defined(&FHC_RES_MASK);
eval 'sub FHC_RES_1024 () {0x;}' unless defined(&FHC_RES_1024);
eval 'sub FHC_RES_1152 () {0x800;}' unless defined(&FHC_RES_1152);
eval 'sub FHC_RES_1280 () {0x1000;}' unless defined(&FHC_RES_1280);
eval 'sub FHC_RES_1600 () {0x1800;}' unless defined(&FHC_RES_1600);
eval 'sub FHC_CPU_MASK () {0x600;}' unless defined(&FHC_CPU_MASK);
eval 'sub FHC_CPU_SPARC () {0x;}' unless defined(&FHC_CPU_SPARC);
eval 'sub FHC_CPU_68020 () {0x200;}' unless defined(&FHC_CPU_68020);
eval 'sub FHC_CPU_386 () {0x400;}' unless defined(&FHC_CPU_386);
eval 'sub FHC_TEST () {0x100;}' unless defined(&FHC_TEST);
eval 'sub FHC_TESTX_MASK () {0xf0;}' unless defined(&FHC_TESTX_MASK);
eval 'sub FHC_TESTX_SHIFT () {4;}' unless defined(&FHC_TESTX_SHIFT);
eval 'sub FHC_TESTY_MASK () {0xf;}' unless defined(&FHC_TESTY_MASK);
eval 'sub FHC_TESTY_SHIFT () {0;}' unless defined(&FHC_TESTY_SHIFT);
eval 'sub CG6_FBC_MODE () {0x4;}' unless defined(&CG6_FBC_MODE);
eval 'sub CG6_FBC_CLIP () {0x8;}' unless defined(&CG6_FBC_CLIP);
eval 'sub CG6_FBC_S () {0x10;}' unless defined(&CG6_FBC_S);
eval 'sub CG6_FBC_DRAW () {0x14;}' unless defined(&CG6_FBC_DRAW);
eval 'sub CG6_FBC_BLIT () {0x18;}' unless defined(&CG6_FBC_BLIT);
eval 'sub CG6_FBC_FONT () {0x1c;}' unless defined(&CG6_FBC_FONT);
eval 'sub CG6_FBC_X0 () {0x80;}' unless defined(&CG6_FBC_X0);
eval 'sub CG6_FBC_Y0 () {0x84;}' unless defined(&CG6_FBC_Y0);
eval 'sub CG6_FBC_Z0 () {0x88;}' unless defined(&CG6_FBC_Z0);
eval 'sub CB6_FBC_C0 () {0x8c;}' unless defined(&CB6_FBC_C0);
eval 'sub CG6_FBC_X1 () {0x90;}' unless defined(&CG6_FBC_X1);
eval 'sub CG6_FBC_Y1 () {0x94;}' unless defined(&CG6_FBC_Y1);
eval 'sub CG6_FBC_Z1 () {0x98;}' unless defined(&CG6_FBC_Z1);
eval 'sub CB6_FBC_C1 () {0x9c;}' unless defined(&CB6_FBC_C1);
eval 'sub CG6_FBC_X2 () {0xa0;}' unless defined(&CG6_FBC_X2);
eval 'sub CG6_FBC_Y2 () {0xa4;}' unless defined(&CG6_FBC_Y2);
eval 'sub CG6_FBC_Z2 () {0xa8;}' unless defined(&CG6_FBC_Z2);
eval 'sub CB6_FBC_C2 () {0xac;}' unless defined(&CB6_FBC_C2);
eval 'sub CG6_FBC_X3 () {0xb0;}' unless defined(&CG6_FBC_X3);
eval 'sub CG6_FBC_Y3 () {0xb4;}' unless defined(&CG6_FBC_Y3);
eval 'sub CG6_FBC_Z3 () {0xb8;}' unless defined(&CG6_FBC_Z3);
eval 'sub CB6_FBC_C3 () {0xbc;}' unless defined(&CB6_FBC_C3);
eval 'sub CG6_FBC_OFFX () {0xc0;}' unless defined(&CG6_FBC_OFFX);
eval 'sub CG6_FBC_OFFY () {0xc4;}' unless defined(&CG6_FBC_OFFY);
eval 'sub CG6_FBC_INCX () {0xd0;}' unless defined(&CG6_FBC_INCX);
eval 'sub CG6_FBC_INCY () {0xd4;}' unless defined(&CG6_FBC_INCY);
eval 'sub CG6_FBC_CLIPMINX () {0xe0;}' unless defined(&CG6_FBC_CLIPMINX);
eval 'sub CG6_FBC_CLIPMINY () {0xe4;}' unless defined(&CG6_FBC_CLIPMINY);
eval 'sub CG6_FBC_CLIPMAXX () {0xf0;}' unless defined(&CG6_FBC_CLIPMAXX);
eval 'sub CG6_FBC_CLIPMAXY () {0xf4;}' unless defined(&CG6_FBC_CLIPMAXY);
eval 'sub CG6_FBC_FG () {0x100;}' unless defined(&CG6_FBC_FG);
eval 'sub CG6_FBC_BG () {0x104;}' unless defined(&CG6_FBC_BG);
eval 'sub CG6_FBC_ALU () {0x108;}' unless defined(&CG6_FBC_ALU);
eval 'sub CG6_FBC_PM () {0x10c;}' unless defined(&CG6_FBC_PM);
eval 'sub CG6_FBC_PIXELM () {0x110;}' unless defined(&CG6_FBC_PIXELM);
eval 'sub CG6_FBC_PATALIGN () {0x11c;}' unless defined(&CG6_FBC_PATALIGN);
eval 'sub CG6_FBC_PATTERN () {0x120;}' unless defined(&CG6_FBC_PATTERN);
eval 'sub CG6_FBC_APOINTX () {0x800;}' unless defined(&CG6_FBC_APOINTX);
eval 'sub CG6_FBC_APOINTY () {0x804;}' unless defined(&CG6_FBC_APOINTY);
eval 'sub CG6_FBC_APOINTZ () {0x808;}' unless defined(&CG6_FBC_APOINTZ);
eval 'sub CG6_FBC_RPOINTX () {0x810;}' unless defined(&CG6_FBC_RPOINTX);
eval 'sub CG6_FBC_RPOINTY () {0x814;}' unless defined(&CG6_FBC_RPOINTY);
eval 'sub CG6_FBC_RPOINTZ () {0x818;}' unless defined(&CG6_FBC_RPOINTZ);
eval 'sub CG6_FBC_POINTR () {0x830;}' unless defined(&CG6_FBC_POINTR);
eval 'sub CG6_FBC_POINTG () {0x834;}' unless defined(&CG6_FBC_POINTG);
eval 'sub CG6_FBC_POINTB () {0x838;}' unless defined(&CG6_FBC_POINTB);
eval 'sub CG6_FBC_POINTA () {0x83c;}' unless defined(&CG6_FBC_POINTA);
eval 'sub CG6_FBC_ALINEX () {0x840;}' unless defined(&CG6_FBC_ALINEX);
eval 'sub CG6_FBC_ALINEY () {0x844;}' unless defined(&CG6_FBC_ALINEY);
eval 'sub CG6_FBC_ALINEZ () {0x848;}' unless defined(&CG6_FBC_ALINEZ);
eval 'sub CG6_FBC_RLINEX () {0x850;}' unless defined(&CG6_FBC_RLINEX);
eval 'sub CG6_FBC_RLINEY () {0x854;}' unless defined(&CG6_FBC_RLINEY);
eval 'sub CG6_FBC_RLINEZ () {0x858;}' unless defined(&CG6_FBC_RLINEZ);
eval 'sub CG6_FBC_LINER () {0x870;}' unless defined(&CG6_FBC_LINER);
eval 'sub CG6_FBC_LINEG () {0x874;}' unless defined(&CG6_FBC_LINEG);
eval 'sub CG6_FBC_LINEB () {0x878;}' unless defined(&CG6_FBC_LINEB);
eval 'sub CG6_FBC_LINEA () {0x87c;}' unless defined(&CG6_FBC_LINEA);
eval 'sub CG6_FBC_ATRIX () {0x880;}' unless defined(&CG6_FBC_ATRIX);
eval 'sub CG6_FBC_ATRIY () {0x884;}' unless defined(&CG6_FBC_ATRIY);
eval 'sub CG6_FBC_ATRIZ () {0x888;}' unless defined(&CG6_FBC_ATRIZ);
eval 'sub CG6_FBC_RTRIX () {0x890;}' unless defined(&CG6_FBC_RTRIX);
eval 'sub CG6_FBC_RTRIY () {0x894;}' unless defined(&CG6_FBC_RTRIY);
eval 'sub CG6_FBC_RTRIZ () {0x898;}' unless defined(&CG6_FBC_RTRIZ);
eval 'sub CG6_FBC_TRIR () {0x8b0;}' unless defined(&CG6_FBC_TRIR);
eval 'sub CG6_FBC_TRIG () {0x8b4;}' unless defined(&CG6_FBC_TRIG);
eval 'sub CG6_FBC_TRIB () {0x8b8;}' unless defined(&CG6_FBC_TRIB);
eval 'sub CG6_FBC_TRIA () {0x8bc;}' unless defined(&CG6_FBC_TRIA);
eval 'sub CG6_FBC_AQUADX () {0x8c0;}' unless defined(&CG6_FBC_AQUADX);
eval 'sub CG6_FBC_AQUADY () {0x8c4;}' unless defined(&CG6_FBC_AQUADY);
eval 'sub CG6_FBC_AQUADZ () {0x8c8;}' unless defined(&CG6_FBC_AQUADZ);
eval 'sub CG6_FBC_RQUADX () {0x8d0;}' unless defined(&CG6_FBC_RQUADX);
eval 'sub CG6_FBC_RQUADY () {0x8d4;}' unless defined(&CG6_FBC_RQUADY);
eval 'sub CG6_FBC_RQUADZ () {0x8d8;}' unless defined(&CG6_FBC_RQUADZ);
eval 'sub CG6_FBC_QUADR () {0x8f0;}' unless defined(&CG6_FBC_QUADR);
eval 'sub CG6_FBC_QUADG () {0x8f4;}' unless defined(&CG6_FBC_QUADG);
eval 'sub CG6_FBC_QUADB () {0x8f8;}' unless defined(&CG6_FBC_QUADB);
eval 'sub CG6_FBC_QUADA () {0x8fc;}' unless defined(&CG6_FBC_QUADA);
eval 'sub CG6_FBC_ARECTX () {0x900;}' unless defined(&CG6_FBC_ARECTX);
eval 'sub CG6_FBC_ARECTY () {0x904;}' unless defined(&CG6_FBC_ARECTY);
eval 'sub CG6_FBC_ARECTZ () {0x908;}' unless defined(&CG6_FBC_ARECTZ);
eval 'sub CG6_FBC_RRECTX () {0x910;}' unless defined(&CG6_FBC_RRECTX);
eval 'sub CG6_FBC_RRECTY () {0x914;}' unless defined(&CG6_FBC_RRECTY);
eval 'sub CG6_FBC_RRECTZ () {0x918;}' unless defined(&CG6_FBC_RRECTZ);
eval 'sub CG6_FBC_RRECTR () {0x930;}' unless defined(&CG6_FBC_RRECTR);
eval 'sub CG6_FBC_RRECTG () {0x934;}' unless defined(&CG6_FBC_RRECTG);
eval 'sub CG6_FBC_RRECTB () {0x938;}' unless defined(&CG6_FBC_RRECTB);
eval 'sub CG6_FBC_RRECTA () {0x938;}' unless defined(&CG6_FBC_RRECTA);
eval 'sub FBC_MODE_VAL () {( 0x200000 | 0x20000 | 0x8000 | 0x2000 | 0x1000 | 0x200 | 0x80 );}' unless defined(&FBC_MODE_VAL);
eval 'sub FBC_MODE_MASK () {( 0x300000 | 0x60000 | 0x18000 | 0x6000 | 0x1800 | 0x600 | 0x180 );}' unless defined(&FBC_MODE_MASK);
eval 'sub FBC_S_GXINPROGRESS () {0x10000000;}' unless defined(&FBC_S_GXINPROGRESS);
eval 'sub FBC_BLIT_UNKNOWN () {0x80000000;}' unless defined(&FBC_BLIT_UNKNOWN);
eval 'sub FBC_BLIT_GXFULL () {0x20000000;}' unless defined(&FBC_BLIT_GXFULL);
eval 'sub FBC_DRAW_UNKNOWN () {0x80000000;}' unless defined(&FBC_DRAW_UNKNOWN);
eval 'sub FBC_DRAW_GXFULL () {0x20000000;}' unless defined(&FBC_DRAW_GXFULL);
eval 'sub FBC_ALU_COPY () {( 0x80000000 | 0x20000000 | 0x800000 | 0x | 0x | 0x8000000 | 0x1000000 | 0xcccc );}' unless defined(&FBC_ALU_COPY);
eval 'sub FBC_ALU_FILL () {( 0x80000000 | 0x20000000 | 0x800000 | 0x | 0x | 0x8000000 | 0x1000000 | 0xff00 );}' unless defined(&FBC_ALU_FILL);
eval 'sub FBC_ALU_FLIP () {( 0x80000000 | 0x20000000 | 0x800000 | 0x | 0x | 0x8000000 | 0x1000000 | 0x5555 );}' unless defined(&FBC_ALU_FLIP);
eval 'sub CG6_TEC_MV () {0x;}' unless defined(&CG6_TEC_MV);
eval 'sub CG6_TEC_CLIP () {0x4;}' unless defined(&CG6_TEC_CLIP);
eval 'sub CG6_TEC_VDC () {0x8;}' unless defined(&CG6_TEC_VDC);
eval 'sub CG6_THC_HSYNC1 () {0x800;}' unless defined(&CG6_THC_HSYNC1);
eval 'sub CG6_THC_HSYNC2 () {0x804;}' unless defined(&CG6_THC_HSYNC2);
eval 'sub CG6_THC_HSYNC3 () {0x808;}' unless defined(&CG6_THC_HSYNC3);
eval 'sub CG6_THC_VSYNC1 () {0x80c;}' unless defined(&CG6_THC_VSYNC1);
eval 'sub CG6_THC_VSYNC2 () {0x810;}' unless defined(&CG6_THC_VSYNC2);
eval 'sub CG6_THC_REFRESH () {0x814;}' unless defined(&CG6_THC_REFRESH);
eval 'sub CG6_THC_MISC () {0x818;}' unless defined(&CG6_THC_MISC);
eval 'sub CG6_THC_CURSXY () {0x8fc;}' unless defined(&CG6_THC_CURSXY);
eval 'sub CG6_THC_CURSMASK () {0x900;}' unless defined(&CG6_THC_CURSMASK);
eval 'sub CG6_THC_CURSBITS () {0x980;}' unless defined(&CG6_THC_CURSBITS);
eval 'sub THC_CURSOFF () {((65536-32) | ((65536-32) << 16));}' unless defined(&THC_CURSOFF);
eval 'sub THC_MISC_REV_M () {0xf0000;}' unless defined(&THC_MISC_REV_M);
eval 'sub THC_MISC_REV_S () {16;}' unless defined(&THC_MISC_REV_S);
eval 'sub THC_MISC_RESET () {0x1000;}' unless defined(&THC_MISC_RESET);
eval 'sub THC_MISC_VIDEN () {0x400;}' unless defined(&THC_MISC_VIDEN);
eval 'sub THC_MISC_SYNC () {0x200;}' unless defined(&THC_MISC_SYNC);
eval 'sub THC_MISC_VSYNC () {0x100;}' unless defined(&THC_MISC_VSYNC);
eval 'sub THC_MISC_SYNCEN () {0x80;}' unless defined(&THC_MISC_SYNCEN);
eval 'sub THC_MISC_CURSRES () {0x40;}' unless defined(&THC_MISC_CURSRES);
eval 'sub THC_MISC_INTEN () {0x20;}' unless defined(&THC_MISC_INTEN);
eval 'sub THC_MISC_INTR () {0x10;}' unless defined(&THC_MISC_INTR);
eval 'sub THC_MISC_CYCLS () {0xf;}' unless defined(&THC_MISC_CYCLS);
eval 'sub CG6_USER_FBC () {0x70000000;}' unless defined(&CG6_USER_FBC);
eval 'sub CG6_USER_TEC () {0x70001000;}' unless defined(&CG6_USER_TEC);
eval 'sub CG6_USER_BTREGS () {0x70002000;}' unless defined(&CG6_USER_BTREGS);
eval 'sub CG6_USER_FHC () {0x70004000;}' unless defined(&CG6_USER_FHC);
eval 'sub CG6_USER_THC () {0x70005000;}' unless defined(&CG6_USER_THC);
eval 'sub CG6_USER_ROM () {0x70006000;}' unless defined(&CG6_USER_ROM);
eval 'sub CG6_USER_RAM () {0x70016000;}' unless defined(&CG6_USER_RAM);
eval 'sub CG6_USER_DHC () {0x80000000;}' unless defined(&CG6_USER_DHC);
unless(defined(&THC_READ)) {
    sub THC_READ {
	my($sc,$r) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_thc_regs, ($r)));
    }
}
unless(defined(&THC_WRITE)) {
    sub THC_WRITE {
	my($sc,$r,$v) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_thc_regs, ($r), ($v)));
    }
}
unless(defined(&TEC_READ)) {
    sub TEC_READ {
	my($sc,$r) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_tec_regs, ($r)));
    }
}
unless(defined(&TEC_WRITE)) {
    sub TEC_WRITE {
	my($sc,$r,$v) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_tec_regs, ($r), ($v)));
    }
}
unless(defined(&FHC_READ)) {
    sub FHC_READ {
	my($sc) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_fhc_regs,  &CG6_FHC));
    }
}
unless(defined(&FHC_WRITE)) {
    sub FHC_WRITE {
	my($sc,$v) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_fhc_regs,  &CG6_FHC, ($v)));
    }
}
unless(defined(&FBC_READ)) {
    sub FBC_READ {
	my($sc,$r) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_fbc_regs, ($r)));
    }
}
unless(defined(&FBC_WRITE)) {
    sub FBC_WRITE {
	my($sc,$r,$v) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_fbc_regs, ($r), ($v)));
    }
}
unless(defined(&BT_WRITE)) {
    sub BT_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_bt_regs, ($reg), ($val)));
    }
}
unless(defined(&BT_READ)) {
    sub BT_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_bt_regs, ($reg)));
    }
}
unless(defined(&BT_BARRIER)) {
    sub BT_BARRIER {
	my($sc,$reg,$flags) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_bustag, ($sc)-> &sc_bt_regs, ($reg), $sizeof{ &u_int32_t}, ($flags)));
    }
}
unless(defined(&CG6_BLIT_WAIT)) {
    sub CG6_BLIT_WAIT {
	my($sc) = @_;
	eval q( &while (( &FBC_READ($sc,  &CG6_FBC_BLIT) & ( &FBC_BLIT_UNKNOWN| &FBC_BLIT_GXFULL)) == ( &FBC_BLIT_UNKNOWN| &FBC_BLIT_GXFULL)));
    }
}
unless(defined(&CG6_DRAW_WAIT)) {
    sub CG6_DRAW_WAIT {
	my($sc) = @_;
	eval q( &while (( &FBC_READ($sc,  &CG6_FBC_DRAW) & ( &FBC_DRAW_UNKNOWN| &FBC_DRAW_GXFULL)) == ( &FBC_DRAW_UNKNOWN| &FBC_DRAW_GXFULL)));
    }
}
unless(defined(&CG6_DRAIN)) {
    sub CG6_DRAIN {
	my($sc) = @_;
	eval q( &while ( &FBC_READ($sc,  &CG6_FBC_S) &  &FBC_S_GXINPROGRESS));
    }
}
eval 'sub CG6_MAX_CURSOR () {32;}' unless defined(&CG6_MAX_CURSOR);
eval 'sub CG6_CFFLAG_NOACCEL () {0x1;}' unless defined(&CG6_CFFLAG_NOACCEL);
1;
